# RxPrescriptionProcessSP - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **RxPrescriptionProcessSP**

## SearchParameter: RxPrescriptionProcessSP 

| | |
| :--- | :--- |
| *Official URL*:https://gematik.de/fhir/epa-medication/SearchParameter/rx-prescription-process-sp | *Version*:1.3.0 |
| Active as of 2025-12-15 | *Computable Name*:RxPrescriptionProcessParameter |
| **Copyright/Legal**: gematik GmbH / Dieser Implementation Guide ist lizenziert unter[Apache License](./license.md), Version 2.0. | |

 
Returns Medications, MedicationDispenses or MedicationStatement with the Rx Prescription Process Identifier. 



## Resource Content

```json
{
  "resourceType" : "SearchParameter",
  "id" : "rx-prescription-process-sp",
  "url" : "https://gematik.de/fhir/epa-medication/SearchParameter/rx-prescription-process-sp",
  "version" : "1.3.0",
  "name" : "RxPrescriptionProcessParameter",
  "status" : "active",
  "date" : "2025-12-15",
  "publisher" : "gematik GmbH",
  "contact" : [
    {
      "name" : "gematik GmbH",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.gematik.de"
        },
        {
          "system" : "email",
          "value" : "patientteam [ at ] gematik.de"
        }
      ]
    }
  ],
  "description" : "Returns Medications, MedicationDispenses or MedicationStatement with the Rx Prescription Process Identifier.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "DE"
        }
      ]
    }
  ],
  "code" : "rx-prescription",
  "base" : ["Medication", "MedicationDispense", "MedicationStatement"],
  "type" : "token",
  "expression" : "extension.where(url = 'https://gematik.de/fhir/epa-medication/StructureDefinition/rx-prescription-process-identifier').value"
}

```
