# DerivedFromSP - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **DerivedFromSP**

## SearchParameter: DerivedFromSP 

| | |
| :--- | :--- |
| *Official URL*:https://gematik.de/fhir/epa-medication/SearchParameter/derived-from-sp | *Version*:1.3.0 |
| Active as of 2025-12-15 | *Computable Name*:DerivedFromSP |
| **Copyright/Legal**: gematik GmbH / Dieser Implementation Guide ist lizenziert unter[Apache License](./license.md), Version 2.0. | |

 
Search by resources from which the medication statement is derived 



## Resource Content

```json
{
  "resourceType" : "SearchParameter",
  "id" : "derived-from-sp",
  "url" : "https://gematik.de/fhir/epa-medication/SearchParameter/derived-from-sp",
  "version" : "1.3.0",
  "name" : "DerivedFromSP",
  "status" : "active",
  "date" : "2025-12-15",
  "publisher" : "gematik GmbH",
  "contact" : [
    {
      "name" : "gematik GmbH",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.gematik.de"
        },
        {
          "system" : "email",
          "value" : "patientteam [ at ] gematik.de"
        }
      ]
    }
  ],
  "description" : "Search by resources from which the medication statement is derived",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "DE"
        }
      ]
    }
  ],
  "code" : "derived-from",
  "base" : ["MedicationStatement"],
  "type" : "reference",
  "expression" : "MedicationStatement.derivedFrom",
  "target" : ["MedicationDispense", "MedicationRequest"],
  "multipleOr" : false,
  "multipleAnd" : true
}

```
