# BasedOnEMPSP - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **BasedOnEMPSP**

## SearchParameter: BasedOnEMPSP 

| | |
| :--- | :--- |
| *Official URL*:https://gematik.de/fhir/epa-medication/SearchParameter/based-on-emp-sp | *Version*:1.3.0 |
| Active as of 2025-12-15 | *Computable Name*:IsEMPSP |
| **Copyright/Legal**: gematik GmbH / Dieser Implementation Guide ist lizenziert unter[Apache License](./license.md), Version 2.0. | |

 
Liefert alle Referencen, die einen eMP bezug haben 



## Resource Content

```json
{
  "resourceType" : "SearchParameter",
  "id" : "based-on-emp-sp",
  "url" : "https://gematik.de/fhir/epa-medication/SearchParameter/based-on-emp-sp",
  "version" : "1.3.0",
  "name" : "IsEMPSP",
  "status" : "active",
  "date" : "2025-12-15",
  "publisher" : "gematik GmbH",
  "contact" : [
    {
      "name" : "gematik GmbH",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.gematik.de"
        },
        {
          "system" : "email",
          "value" : "patientteam [ at ] gematik.de"
        }
      ]
    }
  ],
  "description" : "Liefert alle Referencen, die einen eMP bezug haben",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "DE"
        }
      ]
    }
  ],
  "code" : "based-on-emp",
  "base" : ["MedicationStatement"],
  "type" : "reference",
  "expression" : "Resource.basedOn.where(extension('https://gematik.de/fhir/epa-medication/StructureDefinition/is-emp-extension').value = true)",
  "target" : ["MedicationRequest"],
  "multipleOr" : false,
  "multipleAnd" : false
}

```
