# Arzt - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **Arzt**

## Example Practitioner: Arzt

Das bereitgestellte Beispiel dient ausschließlich als technische Illustration und soll darstellen, wie Elemente befüllt werden könnten oder wie verschiedene Instanzen zusammenhängen und hat keinen Anspruch daran, fachlich korrekt oder sinnvoll zu sein.

Profile: [Practitioner in gematik Directoryversion: null1.0.0)](https://simplifier.net/resolve?scope=de.gematik.fhir.directory@1.0.0&canonical=https://gematik.de/fhir/directory/StructureDefinition/PractitionerDirectory)

Tag: Synchronized from LDAP Directory (Details: Origin code ldap = 'Synchronized from LDAP Directory')

**identifier**: `https://gematik.de/fhir/sid/telematik-id`/1-1.58.00000056, `https://fhir.kbv.de/NamingSystem/KBV_NS_Base_ANR`/123456789

**active**: true

**name**: Dr. Max Manfred Mustermann



## Resource Content

```json
{
  "resourceType" : "Practitioner",
  "id" : "498c345f-31f5-4da6-9f04-00fa2bc8af7c",
  "meta" : {
    "profile" : [
      "https://gematik.de/fhir/directory/StructureDefinition/PractitionerDirectory|1.0.0"
    ],
    "tag" : [
      {
        "system" : "https://gematik.de/fhir/directory/CodeSystem/Origin",
        "code" : "ldap"
      }
    ]
  },
  "identifier" : [
    {
      "system" : "https://gematik.de/fhir/sid/telematik-id",
      "value" : "1-1.58.00000056"
    },
    {
      "system" : "https://fhir.kbv.de/NamingSystem/KBV_NS_Base_ANR",
      "value" : "123456789"
    }
  ],
  "active" : true,
  "name" : [
    {
      "text" : "Dr. Max Manfred Mustermann",
      "family" : "Musterman",
      "given" : ["Max", "Manfred"],
      "prefix" : ["Dr."]
    }
  ]
}

```
