# ExampleEpaOpProvideDispensationERPInputParameters1 - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **ExampleEpaOpProvideDispensationERPInputParameters1**

## Example Parameters: ExampleEpaOpProvideDispensationERPInputParameters1

Das bereitgestellte Beispiel dient ausschließlich als technische Illustration und soll darstellen, wie Elemente befüllt werden könnten oder wie verschiedene Instanzen zusammenhängen und hat keinen Anspruch daran, fachlich korrekt oder sinnvoll zu sein.



## Resource Content

```json
{
  "resourceType" : "Parameters",
  "id" : "example-epa-op-provide-dispensation-erp-input-parameters-1",
  "meta" : {
    "profile" : [
      "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-op-provide-dispensation-erp-input-parameters|1.3.0"
    ]
  },
  "parameter" : [
    {
      "name" : "rxDispensation",
      "part" : [
        {
          "name" : "prescriptionId",
          "valueIdentifier" : {
            "system" : "https://gematik.de/fhir/erp/NamingSystem/GEM_ERP_NS_PrescriptionId",
            "value" : "160.100.000.000.011.09"
          }
        },
        {
          "name" : "authoredOn",
          "valueDate" : "2025-09-06"
        },
        {
          "name" : "medicationDispense",
          "resource" : {
            "resourceType" : "MedicationDispense",
            "id" : "72f86151-cdb2-472c-8e98-e5ba71191e1d",
            "meta" : {
              "profile" : [
                "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-dispense|1.3.0"
              ]
            },
            "status" : "completed",
            "medicationReference" : {
              "reference" : "Medication/9fae333f-92b1-4f03-b838-cd5c5d2285b5"
            },
            "subject" : {
              "identifier" : {
                "system" : "http://fhir.de/sid/gkv/kvid-10",
                "value" : "X110411319"
              }
            },
            "performer" : [
              {
                "actor" : {
                  "reference" : "Organization/ccc03731-4c38-4b48-bd41-583766b796c6",
                  "identifier" : {
                    "type" : {
                      "coding" : [
                        {
                          "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                          "code" : "PRN",
                          "display" : "Provider number"
                        }
                      ]
                    },
                    "system" : "https://gematik.de/fhir/sid/telematik-id",
                    "value" : "9-2.58.00000023"
                  },
                  "display" : "gematik Apotheke"
                }
              }
            ],
            "whenHandedOver" : "2025-09-08",
            "substitution" : {
              "wasSubstituted" : false
            }
          }
        },
        {
          "name" : "medication",
          "resource" : {
            "resourceType" : "Medication",
            "id" : "9fae333f-92b1-4f03-b838-cd5c5d2285b5",
            "meta" : {
              "profile" : [
                "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication|1.3.0"
              ]
            },
            "extension" : [
              {
                "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-type-extension",
                "valueCoding" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "763158003",
                  "display" : "Medicinal product (product)"
                }
              },
              {
                "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/drug-category-extension",
                "valueCoding" : {
                  "system" : "https://gematik.de/fhir/epa-medication/CodeSystem/epa-drug-category-cs",
                  "code" : "00"
                }
              },
              {
                "url" : "http://fhir.de/StructureDefinition/normgroesse",
                "valueCode" : "N1"
              },
              {
                "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/medication-id-vaccine-extension",
                "valueBoolean" : false
              }
            ],
            "code" : {
              "coding" : [
                {
                  "system" : "http://fhir.de/CodeSystem/ifa/pzn",
                  "code" : "04773414"
                }
              ],
              "text" : "Doxycyclin AL 200 T, 10 Tabletten N1"
            },
            "status" : "active",
            "form" : {
              "coding" : [
                {
                  "system" : "https://fhir.kbv.de/CodeSystem/KBV_CS_SFHIR_KBV_DARREICHUNGSFORM",
                  "code" : "TAB"
                }
              ]
            },
            "amount" : {
              "numerator" : {
                "extension" : [
                  {
                    "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/medication-total-quantity-formulation-extension",
                    "valueString" : "10"
                  }
                ],
                "unit" : "Tabletten"
              },
              "denominator" : {
                "value" : 1
              }
            },
            "ingredient" : [
              {
                "itemCodeableConcept" : {
                  "coding" : [
                    {
                      "system" : "http://fhir.de/CodeSystem/ask",
                      "code" : "03876"
                    }
                  ],
                  "text" : "Doxycyclin"
                },
                "strength" : {
                  "numerator" : {
                    "value" : 200,
                    "unit" : "mg"
                  },
                  "denominator" : {
                    "value" : 1,
                    "unit" : "Tbl."
                  }
                }
              }
            ]
          }
        },
        {
          "name" : "organization",
          "resource" : {
            "resourceType" : "Organization",
            "id" : "ccc03731-4c38-4b48-bd41-583766b796c6",
            "meta" : {
              "profile" : [
                "https://gematik.de/fhir/directory/StructureDefinition/OrganizationDirectory|1.0.0"
              ],
              "tag" : [
                {
                  "system" : "https://gematik.de/fhir/directory/CodeSystem/Origin",
                  "code" : "ldap"
                }
              ]
            },
            "identifier" : [
              {
                "system" : "https://gematik.de/fhir/sid/telematik-id",
                "value" : "9-2.58.00000023"
              }
            ],
            "active" : true,
            "type" : [
              {
                "coding" : [
                  {
                    "system" : "https://gematik.de/fhir/directory/CodeSystem/OrganizationProfessionOID",
                    "code" : "1.2.276.0.76.4.54",
                    "display" : "Öffentliche Apotheke"
                  }
                ]
              }
            ],
            "name" : "gematik Apotheke",
            "alias" : ["Apotheke"],
            "address" : [
              {
                "text" : "gematik Apotheke\nFriedrichstr. 136,\n10117 Berlin",
                "line" : ["Friedrichstr. 136"],
                "city" : "Berlin",
                "district" : "Mitte",
                "state" : "Berlin",
                "postalCode" : "10117",
                "country" : "DE"
              }
            ],
            "contact" : [
              {
                "purpose" : {
                  "coding" : [
                    {
                      "system" : "http://terminology.hl7.org/CodeSystem/contactentity-type",
                      "code" : "ADMIN"
                    }
                  ]
                },
                "name" : {
                  "text" : "gematik ITSM"
                },
                "telecom" : [
                  {
                    "system" : "email",
                    "value" : "betrieb@gematik.de"
                  }
                ]
              }
            ]
          }
        }
      ]
    }
  ]
}

```
