# ExpEPAOpLinkEMPEntryOutputParameters - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **ExpEPAOpLinkEMPEntryOutputParameters**

## Example Parameters: ExpEPAOpLinkEMPEntryOutputParameters



## Resource Content

```json
{
  "resourceType" : "Parameters",
  "id" : "example-epa-op-link-emp-entry-output-parameters-1",
  "meta" : {
    "profile" : [
      "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-op-link-emp-entry-output-parameters|1.3.0"
    ]
  },
  "parameter" : [
    {
      "name" : "medicationStatement",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "3afe43bc-8b57-417f-9e84-a70ea5062a6c",
        "meta" : {
          "versionId" : "2",
          "lastUpdated" : "2026-11-01T15:43:33.244Z",
          "profile" : [
            "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-statement|1.3.0"
          ]
        },
        "extension" : [
          {
            "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/context-extension",
            "valueCode" : "MANUAL"
          },
          {
            "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-MedicationStatement.renderedDosageInstruction",
            "valueMarkdown" : "1-0-0-0 Stück"
          },
          {
            "extension" : [
              {
                "url" : "algorithmVersion",
                "valueString" : "1.0.1"
              },
              {
                "url" : "language",
                "valueCode" : "de-DE"
              }
            ],
            "url" : "http://ig.fhir.de/igs/medication/StructureDefinition/GeneratedDosageInstructionsMeta"
          }
        ],
        "basedOn" : [
          {
            "extension" : [
              {
                "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/is-emp-extension",
                "valueBoolean" : true
              }
            ],
            "reference" : "MedicationRequest/266620a9-2c26-41c1-b0cb-a10947b867f5"
          }
        ],
        "status" : "unknown",
        "medicationReference" : {
          "reference" : "Medication/b43cb3c2-552a-4da1-9eaa-605ac532a83d"
        },
        "subject" : {
          "identifier" : {
            "system" : "http://fhir.de/sid/gkv/kvid-10",
            "value" : "X110411319"
          }
        },
        "effectivePeriod" : {
          "start" : "2026-11-01"
        },
        "dateAsserted" : "2026-11-01",
        "dosage" : [
          {
            "timing" : {
              "repeat" : {
                "frequency" : 1,
                "period" : 1,
                "periodUnit" : "d",
                "when" : ["MORN"]
              }
            },
            "doseAndRate" : [
              {
                "doseQuantity" : {
                  "value" : 1,
                  "unit" : "Stück",
                  "system" : "https://fhir.kbv.de/CodeSystem/KBV_CS_SFHIR_BMP_DOSIEREINHEIT",
                  "code" : "1"
                }
              }
            ]
          }
        ]
      }
    },
    {
      "name" : "eMPEntry",
      "resource" : {
        "resourceType" : "MedicationRequest",
        "id" : "266620a9-2c26-41c1-b0cb-a10947b867f5",
        "meta" : {
          "versionId" : "2",
          "lastUpdated" : "2026-11-01T15:43:33.244Z",
          "profile" : [
            "https://gematik.de/fhir/epa-medication/StructureDefinition/emp-medication-request|1.3.0"
          ]
        },
        "extension" : [
          {
            "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/context-extension",
            "valueCode" : "EMP"
          },
          {
            "extension" : [
              {
                "url" : "reference",
                "valueReference" : {
                  "reference" : "MedicationStatement/3afe43bc-8b57-417f-9e84-a70ea5062a6c"
                }
              },
              {
                "url" : "addedOn",
                "valueDateTime" : "2026-11-01T15:43:33.244Z"
              }
            ],
            "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/emp-medicationrequest-activity-extension"
          },
          {
            "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/emp-origin-medication-extension",
            "valueReference" : {
              "reference" : "Medication/d6508f13-9314-4e54-a0c3-3eafe1f356ff"
            }
          },
          {
            "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/reason-patient-instruction-extension",
            "valueString" : "Kopfschmerzen"
          },
          {
            "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/patient-note-extension",
            "valueAnnotation" : {
              "text" : "Alkohol: das Risiko für Magen-Darm-Geschwüre und -Blutungen ist erhöht."
            }
          },
          {
            "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-MedicationRequest.effectiveDosePeriod",
            "valuePeriod" : {
              "start" : "2026-11-02"
            }
          },
          {
            "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-MedicationRequest.renderedDosageInstruction",
            "valueMarkdown" : "1-0-0-0 Stück"
          },
          {
            "extension" : [
              {
                "url" : "algorithmVersion",
                "valueString" : "1.0.1"
              },
              {
                "url" : "language",
                "valueCode" : "de-DE"
              }
            ],
            "url" : "http://ig.fhir.de/igs/medication/StructureDefinition/GeneratedDosageInstructionsMeta"
          }
        ],
        "identifier" : [
          {
            "system" : "https://gematik.de/fhir/sid/emp-identifier",
            "value" : "266620a9-2c26-41c1-b0cb-a10947b867f5"
          }
        ],
        "status" : "active",
        "intent" : "plan",
        "medicationReference" : {
          "reference" : "Medication/b43cb3c2-552a-4da1-9eaa-605ac532a83d"
        },
        "subject" : {
          "identifier" : {
            "system" : "http://fhir.de/sid/gkv/kvid-10",
            "value" : "X110411319"
          }
        },
        "authoredOn" : "2026-11-01",
        "note" : [
          {
            "text" : "Hinweis für den LE"
          }
        ],
        "dosageInstruction" : [
          {
            "timing" : {
              "repeat" : {
                "frequency" : 1,
                "period" : 1,
                "periodUnit" : "d",
                "when" : ["MORN"]
              }
            },
            "doseAndRate" : [
              {
                "doseQuantity" : {
                  "value" : 1,
                  "unit" : "Stück",
                  "system" : "https://fhir.kbv.de/CodeSystem/KBV_CS_SFHIR_BMP_DOSIEREINHEIT",
                  "code" : "1"
                }
              }
            ]
          }
        ]
      }
    },
    {
      "name" : "relatedActivity",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "b6fb1655-820e-4d7e-9255-c76b02e4d085",
        "meta" : {
          "profile" : [
            "https://gematik.de/fhir/epa/StructureDefinition/epa-activity-provenance|1.3.0"
          ]
        },
        "target" : [
          {
            "reference" : "MedicationStatement/3afe43bc-8b57-417f-9e84-a70ea5062a6c/_history/2"
          },
          {
            "reference" : "MedicationRequest/266620a9-2c26-41c1-b0cb-a10947b867f5/_history/2"
          }
        ],
        "recorded" : "2026-11-01T15:43:33.244Z",
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "reference" : "Organization/450a9511-53e5-4af7-be36-a18444bb8dd2",
              "identifier" : {
                "type" : {
                  "coding" : [
                    {
                      "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                      "code" : "PRN"
                    }
                  ]
                },
                "system" : "https://gematik.de/fhir/sid/telematik-id",
                "value" : "9-2.58.00000089"
              },
              "display" : "Die Hausarztpraxis"
            }
          }
        ]
      }
    },
    {
      "name" : "relatedChronology",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "a8ebdbfb-c525-4ab0-a518-bcca6b2df45a",
        "meta" : {
          "profile" : [
            "https://gematik.de/fhir/epa-medication/StructureDefinition/emp-chronology-provenance|1.3.0"
          ]
        },
        "extension" : [
          {
            "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/is-emp-chronology-extension",
            "valueBoolean" : true
          }
        ],
        "target" : [
          {
            "reference" : "MedicationRequest/266620a9-2c26-41c1-b0cb-a10947b867f5/_history/2"
          }
        ],
        "occurredDateTime" : "2026-11-01T15:43:33.244Z",
        "recorded" : "2026-11-01T15:43:33.244Z",
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "reference" : "Organization/450a9511-53e5-4af7-be36-a18444bb8dd2",
              "identifier" : {
                "type" : {
                  "coding" : [
                    {
                      "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                      "code" : "PRN"
                    }
                  ]
                },
                "system" : "https://gematik.de/fhir/sid/telematik-id",
                "value" : "9-2.58.00000089"
              },
              "display" : "Die Hausarztpraxis"
            }
          }
        ]
      }
    }
  ]
}

```
