# ExpEPAOpEMPEntryOutputParametersUpdate - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **ExpEPAOpEMPEntryOutputParametersUpdate**

## Example Parameters: ExpEPAOpEMPEntryOutputParametersUpdate



## Resource Content

```json
{
  "resourceType" : "Parameters",
  "id" : "example-epa-op-emp-entry-output-parameters-2",
  "meta" : {
    "profile" : [
      "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-op-emp-entry-output-parameters|1.3.0"
    ]
  },
  "parameter" : [
    {
      "name" : "empEntry",
      "resource" : {
        "resourceType" : "MedicationRequest",
        "id" : "3dfe8327-dd4c-4e53-a695-cd2e0b21e699",
        "meta" : {
          "versionId" : "2",
          "lastUpdated" : "2026-12-15T14:00:00.400Z",
          "profile" : [
            "https://gematik.de/fhir/epa-medication/StructureDefinition/emp-medication-request|1.3.0"
          ]
        },
        "extension" : [
          {
            "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/context-extension",
            "valueCode" : "EMP"
          },
          {
            "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/reason-patient-instruction-extension",
            "valueString" : "Bluthochdruck"
          },
          {
            "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/patient-note-extension",
            "valueAnnotation" : {
              "text" : "Benazepril kann anfangs Schwindel verursachen - daher zuerst in Ruhe einnehmen und Autofahren vermeiden."
            }
          },
          {
            "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-MedicationRequest.effectiveDosePeriod",
            "valuePeriod" : {
              "start" : "2026-12-01"
            }
          },
          {
            "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/emp-origin-medication-extension",
            "valueReference" : {
              "reference" : "Medication/13c66845-d0ce-43e1-9b0b-884cbbe8df7f"
            }
          },
          {
            "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-MedicationRequest.renderedDosageInstruction",
            "valueMarkdown" : "1-0-1-0 Stück"
          },
          {
            "extension" : [
              {
                "url" : "algorithmVersion",
                "valueString" : "1.0.1"
              },
              {
                "url" : "language",
                "valueCode" : "de-DE"
              }
            ],
            "url" : "http://ig.fhir.de/igs/medication/StructureDefinition/GeneratedDosageInstructionsMeta"
          }
        ],
        "identifier" : [
          {
            "system" : "https://gematik.de/fhir/sid/emp-identifier",
            "value" : "3dfe8327-dd4c-4e53-a695-cd2e0b21e699"
          }
        ],
        "status" : "active",
        "intent" : "plan",
        "medicationReference" : {
          "reference" : "Medication/13c66845-d0ce-43e1-9b0b-884cbbe8df7f"
        },
        "subject" : {
          "identifier" : {
            "system" : "http://fhir.de/sid/gkv/kvid-10",
            "value" : "X110411319"
          }
        },
        "authoredOn" : "2026-12-01",
        "note" : [
          {
            "text" : "Hinweis für den LE"
          }
        ],
        "dosageInstruction" : [
          {
            "timing" : {
              "repeat" : {
                "frequency" : 2,
                "period" : 1,
                "periodUnit" : "d",
                "when" : ["MORN", "EVE"]
              }
            },
            "doseAndRate" : [
              {
                "doseQuantity" : {
                  "value" : 1,
                  "unit" : "Stück",
                  "system" : "https://fhir.kbv.de/CodeSystem/KBV_CS_SFHIR_BMP_DOSIEREINHEIT",
                  "code" : "1"
                }
              }
            ]
          }
        ]
      }
    },
    {
      "name" : "medication",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "13c66845-d0ce-43e1-9b0b-884cbbe8df7f",
        "meta" : {
          "versionId" : "1",
          "lastUpdated" : "2026-12-01T14:00:00.200Z",
          "profile" : [
            "https://gematik.de/fhir/epa-medication/StructureDefinition/emp-medication|1.3.0"
          ]
        },
        "extension" : [
          {
            "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/context-extension",
            "valueCode" : "EMP"
          },
          {
            "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-type-extension",
            "valueCoding" : {
              "system" : "http://snomed.info/sct",
              "code" : "763158003",
              "display" : "Medicinal product (product)"
            }
          },
          {
            "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/drug-category-extension",
            "valueCoding" : {
              "system" : "https://gematik.de/fhir/epa-medication/CodeSystem/epa-drug-category-cs",
              "code" : "00"
            }
          },
          {
            "url" : "http://fhir.de/StructureDefinition/normgroesse",
            "valueCode" : "N3"
          },
          {
            "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/medication-id-vaccine-extension",
            "valueBoolean" : false
          }
        ],
        "identifier" : [
          {
            "system" : "https://gematik.de/fhir/epa-medication/sid/epa-medication-unique-identifier",
            "value" : "D15E4956F59A13CD3BB365799857D6FA9757C62D36DBDB9578D018CA4B6D969F"
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://fhir.de/CodeSystem/ifa/pzn",
              "code" : "04351736",
              "display" : "Benazepril AL 20mg 98 Filmtabletten N3"
            }
          ],
          "text" : "Benazepril AL 20mg 98 Filmtabletten N3"
        },
        "status" : "active",
        "form" : {
          "coding" : [
            {
              "system" : "https://fhir.kbv.de/CodeSystem/KBV_CS_SFHIR_KBV_DARREICHUNGSFORM",
              "code" : "FTA"
            }
          ]
        },
        "amount" : {
          "numerator" : {
            "extension" : [
              {
                "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/medication-total-quantity-formulation-extension",
                "valueString" : "98"
              }
            ],
            "unit" : "Stück"
          },
          "denominator" : {
            "value" : 1
          }
        },
        "ingredient" : [
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://fhir.de/CodeSystem/ask",
                  "code" : "23413"
                }
              ],
              "text" : "Benazepril hydrochlorid"
            },
            "strength" : {
              "numerator" : {
                "value" : 20,
                "unit" : "mg"
              },
              "denominator" : {
                "value" : 1,
                "unit" : "Filmtbl."
              }
            }
          }
        ]
      }
    },
    {
      "name" : "relatedActivity",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "d79a8998-0143-47df-9b07-d0d4d6e8c64b",
        "meta" : {
          "profile" : [
            "https://gematik.de/fhir/epa/StructureDefinition/epa-activity-provenance|1.3.0"
          ]
        },
        "target" : [
          {
            "reference" : "MedicationRequest/3dfe8327-dd4c-4e53-a695-cd2e0b21e699/_history/2"
          }
        ],
        "recorded" : "2026-12-15T14:00:00.100Z",
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "reference" : "Organization/450a9511-53e5-4af7-be36-a18444bb8dd2",
              "identifier" : {
                "type" : {
                  "coding" : [
                    {
                      "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                      "code" : "PRN"
                    }
                  ]
                },
                "system" : "https://gematik.de/fhir/sid/telematik-id",
                "value" : "9-2.58.00000089"
              },
              "display" : "Die Hausarztpraxis"
            }
          }
        ]
      }
    },
    {
      "name" : "relatedChronology",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "6c98e872-4247-4a54-aa7f-6967b099656a",
        "meta" : {
          "profile" : [
            "https://gematik.de/fhir/epa-medication/StructureDefinition/emp-chronology-provenance|1.3.0"
          ]
        },
        "extension" : [
          {
            "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/is-emp-chronology-extension",
            "valueBoolean" : true
          }
        ],
        "target" : [
          {
            "reference" : "MedicationRequest/173439a1-40ee-4b61-bb8c-aab3f5a1af10/_history/2"
          },
          {
            "reference" : "MedicationRequest/e2da4372-accc-4a76-81da-83e43ef9b15a/_history/1"
          },
          {
            "reference" : "MedicationRequest/3dfe8327-dd4c-4e53-a695-cd2e0b21e699/_history/2"
          }
        ],
        "occurredDateTime" : "2026-12-15T14:00:00.100Z",
        "recorded" : "2026-12-15T14:00:00.100Z",
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "reference" : "Organization/450a9511-53e5-4af7-be36-a18444bb8dd2",
              "identifier" : {
                "type" : {
                  "coding" : [
                    {
                      "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                      "code" : "PRN"
                    }
                  ]
                },
                "system" : "https://gematik.de/fhir/sid/telematik-id",
                "value" : "9-2.58.00000089"
              },
              "display" : "Die Hausarztpraxis"
            }
          }
        ]
      }
    }
  ]
}

```
