# ExpEPAOpEmlEntryOutputParameters - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **ExpEPAOpEmlEntryOutputParameters**

## Example Parameters: ExpEPAOpEmlEntryOutputParameters



## Resource Content

```json
{
  "resourceType" : "Parameters",
  "id" : "example-epa-op-eml-entry-output-parameters-1",
  "meta" : {
    "profile" : [
      "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-op-eml-entry-output-parameters|1.3.0"
    ]
  },
  "parameter" : [
    {
      "name" : "medicationStatement",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "71601cdb-8a53-4f26-b5d5-e5457b498e76",
        "meta" : {
          "versionId" : "1",
          "lastUpdated" : "2026-02-22T14:43:33.444Z",
          "profile" : [
            "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-statement|1.3.0"
          ]
        },
        "extension" : [
          {
            "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/context-extension",
            "valueCode" : "MANUAL"
          },
          {
            "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-MedicationStatement.renderedDosageInstruction",
            "valueMarkdown" : "1-0-1-0 Stück"
          },
          {
            "extension" : [
              {
                "url" : "algorithmVersion",
                "valueString" : "1.0.1"
              },
              {
                "url" : "language",
                "valueCode" : "de-DE"
              }
            ],
            "url" : "http://ig.fhir.de/igs/medication/StructureDefinition/GeneratedDosageInstructionsMeta"
          }
        ],
        "status" : "unknown",
        "medicationReference" : {
          "reference" : "Medication/2571d29b-e213-40ec-b817-a1490718f491"
        },
        "subject" : {
          "identifier" : {
            "system" : "http://fhir.de/sid/gkv/kvid-10",
            "value" : "X110411319"
          }
        },
        "effectivePeriod" : {
          "start" : "2026-02-10"
        },
        "dateAsserted" : "2026-02-22",
        "dosage" : [
          {
            "timing" : {
              "repeat" : {
                "frequency" : 2,
                "period" : 1,
                "periodUnit" : "d",
                "when" : ["MORN", "EVE"]
              }
            },
            "doseAndRate" : [
              {
                "doseQuantity" : {
                  "value" : 1,
                  "unit" : "Stück",
                  "system" : "https://fhir.kbv.de/CodeSystem/KBV_CS_SFHIR_BMP_DOSIEREINHEIT",
                  "code" : "1"
                }
              }
            ]
          }
        ]
      }
    },
    {
      "name" : "medication",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "2571d29b-e213-40ec-b817-a1490718f491",
        "meta" : {
          "versionId" : "1",
          "lastUpdated" : "2026-02-22T14:43:33.244Z",
          "profile" : [
            "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication|1.3.0"
          ]
        },
        "extension" : [
          {
            "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-type-extension",
            "valueCoding" : {
              "system" : "http://snomed.info/sct",
              "code" : "781405001",
              "display" : "Medicinal product package (product)"
            }
          },
          {
            "url" : "http://fhir.de/StructureDefinition/normgroesse",
            "valueCode" : "N1"
          }
        ],
        "identifier" : [
          {
            "system" : "https://gematik.de/fhir/epa-medication/sid/epa-medication-unique-identifier",
            "value" : "B849184C973EA5FA7D9751E6FAA6AFCFFD100183596239F84DD2C0FG4C751D67"
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://fhir.de/CodeSystem/ifa/pzn",
              "code" : "14170042",
              "display" : "Diclo-ratiopharm® bei Schmerzen und Fieber 25 mg Filmtabletten"
            }
          ],
          "text" : "Diclo-ratiopharm® bei Schmerzen und Fieber 25 mg Filmtabletten"
        },
        "status" : "active",
        "form" : {
          "coding" : [
            {
              "system" : "https://fhir.kbv.de/CodeSystem/KBV_CS_SFHIR_KBV_DARREICHUNGSFORM",
              "code" : "TAB"
            }
          ]
        },
        "amount" : {
          "numerator" : {
            "extension" : [
              {
                "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/medication-total-quantity-formulation-extension",
                "valueString" : "20 St."
              }
            ],
            "value" : 20,
            "unit" : "St"
          },
          "denominator" : {
            "value" : 1
          }
        }
      }
    },
    {
      "name" : "relatedActivity",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "a36b3ae8-1c1d-4dbb-b209-ee2ee9fc31e6",
        "meta" : {
          "profile" : [
            "https://gematik.de/fhir/epa/StructureDefinition/epa-activity-provenance|1.3.0"
          ]
        },
        "target" : [
          {
            "reference" : "MedicationStatement/71601cdb-8a53-4f26-b5d5-e5457b498e76/_history/1"
          }
        ],
        "recorded" : "2026-08-18T14:43:33.344Z",
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "reference" : "Organization/8B421590-9F7F-46BE-BD1E-C987063AC4F5",
              "identifier" : {
                "type" : {
                  "coding" : [
                    {
                      "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                      "code" : "PRN"
                    }
                  ]
                },
                "system" : "https://gematik.de/fhir/sid/telematik-id",
                "value" : "9-2.58.00000060"
              },
              "display" : "Die Apotheke"
            }
          }
        ]
      }
    }
  ]
}

```
