# ExpEPAOpAddEMPEntryWithReferenceInputParameters - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **ExpEPAOpAddEMPEntryWithReferenceInputParameters**

## Example Parameters: ExpEPAOpAddEMPEntryWithReferenceInputParameters



## Resource Content

```json
{
  "resourceType" : "Parameters",
  "id" : "example-epa-op-add-emp-entry-with-reference-input-parameters-1",
  "meta" : {
    "profile" : [
      "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-op-add-emp-entry-input-parameters|1.3.0"
    ]
  },
  "parameter" : [
    {
      "name" : "acknowledgedChronologyId",
      "valueId" : "0b383501-f078-464b-b984-9fdb6751601b"
    },
    {
      "name" : "medication",
      "part" : [
        {
          "name" : "reference",
          "valueReference" : {
            "reference" : "Medication/fc7b28e8-05ac-4ac8-86d7-7677d9c6134e"
          }
        }
      ]
    },
    {
      "name" : "empEntry",
      "resource" : {
        "resourceType" : "MedicationRequest",
        "id" : "6cc286cc-15a6-48ad-a349-9e8b6a48af75",
        "meta" : {
          "profile" : [
            "https://gematik.de/fhir/epa-medication/StructureDefinition/emp-medication-request|1.3.0"
          ]
        },
        "extension" : [
          {
            "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/context-extension",
            "valueCode" : "EMP"
          },
          {
            "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/reason-patient-instruction-extension",
            "valueString" : "akuten Behandlung von Migräneanfällen mit und ohne Aura"
          },
          {
            "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/patient-note-extension",
            "valueAnnotation" : {
              "text" : "Bitte schützen Sie das Arzneimittel vor hohen Temperaturen und direkter Sonneneinstrahlung."
            }
          },
          {
            "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-MedicationRequest.effectiveDosePeriod",
            "valuePeriod" : {
              "start" : "2026-12-01",
              "end" : "2027-02-01"
            }
          },
          {
            "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/emp-origin-medication-extension",
            "valueReference" : {
              "reference" : "Medication/87f08ba2-da7e-467e-86aa-404d9035297c"
            }
          },
          {
            "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-MedicationRequest.renderedDosageInstruction",
            "valueMarkdown" : "1-0-0-0 Stück"
          },
          {
            "extension" : [
              {
                "url" : "algorithmVersion",
                "valueString" : "1.0.1"
              },
              {
                "url" : "language",
                "valueCode" : "de-DE"
              }
            ],
            "url" : "http://ig.fhir.de/igs/medication/StructureDefinition/GeneratedDosageInstructionsMeta"
          }
        ],
        "status" : "active",
        "intent" : "plan",
        "medicationReference" : {
          "reference" : "Medication/87f08ba2-da7e-467e-86aa-404d9035297c",
          "display" : "Sumatriptan-1a Pharma 100 mg Tabletten"
        },
        "subject" : {
          "identifier" : {
            "system" : "http://fhir.de/sid/gkv/kvid-10",
            "value" : "X110411319"
          }
        },
        "authoredOn" : "2026-11-01",
        "note" : [
          {
            "text" : "Hinweis für den LE"
          }
        ],
        "dosageInstruction" : [
          {
            "timing" : {
              "repeat" : {
                "frequency" : 1,
                "period" : 1,
                "periodUnit" : "d",
                "when" : ["MORN"]
              }
            },
            "doseAndRate" : [
              {
                "doseQuantity" : {
                  "value" : 1,
                  "unit" : "Stück",
                  "system" : "https://fhir.kbv.de/CodeSystem/KBV_CS_SFHIR_BMP_DOSIEREINHEIT",
                  "code" : "1"
                }
              }
            ]
          }
        ]
      }
    }
  ]
}

```
