# ExpEPAOpAddEMPEntryInputParameters - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **ExpEPAOpAddEMPEntryInputParameters**

## Example Parameters: ExpEPAOpAddEMPEntryInputParameters



## Resource Content

```json
{
  "resourceType" : "Parameters",
  "id" : "example-epa-op-add-emp-entry-input-parameters-1",
  "meta" : {
    "profile" : [
      "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-op-add-emp-entry-input-parameters|1.3.0"
    ]
  },
  "parameter" : [
    {
      "name" : "acknowledgedChronologyId",
      "valueId" : "0b383501-f078-464b-b984-9fdb6751601b"
    },
    {
      "name" : "medication",
      "part" : [
        {
          "name" : "resource",
          "resource" : {
            "resourceType" : "Medication",
            "id" : "1193c409-3df4-4b55-b672-811665aaa1b7",
            "meta" : {
              "profile" : [
                "https://gematik.de/fhir/epa-medication/StructureDefinition/emp-medication|1.3.0"
              ]
            },
            "extension" : [
              {
                "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/context-extension",
                "valueCode" : "EMP"
              },
              {
                "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-type-extension",
                "valueCoding" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "763158003",
                  "display" : "Medicinal product (product)"
                }
              },
              {
                "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/drug-category-extension",
                "valueCoding" : {
                  "system" : "https://gematik.de/fhir/epa-medication/CodeSystem/epa-drug-category-cs",
                  "code" : "00"
                }
              },
              {
                "url" : "http://fhir.de/StructureDefinition/normgroesse",
                "valueCode" : "N3"
              },
              {
                "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/medication-id-vaccine-extension",
                "valueBoolean" : false
              }
            ],
            "code" : {
              "coding" : [
                {
                  "system" : "http://fhir.de/CodeSystem/ifa/pzn",
                  "code" : "04351736",
                  "display" : "Benazepril AL 20mg 98 Filmtabletten N3"
                }
              ],
              "text" : "Benazepril AL 20mg 98 Filmtabletten N3"
            },
            "status" : "active",
            "form" : {
              "coding" : [
                {
                  "system" : "https://fhir.kbv.de/CodeSystem/KBV_CS_SFHIR_KBV_DARREICHUNGSFORM",
                  "code" : "FTA"
                }
              ]
            },
            "amount" : {
              "numerator" : {
                "extension" : [
                  {
                    "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/medication-total-quantity-formulation-extension",
                    "valueString" : "98"
                  }
                ],
                "unit" : "Stück"
              },
              "denominator" : {
                "value" : 1
              }
            },
            "ingredient" : [
              {
                "itemCodeableConcept" : {
                  "coding" : [
                    {
                      "system" : "http://fhir.de/CodeSystem/ask",
                      "code" : "23413"
                    }
                  ],
                  "text" : "Benazepril hydrochlorid"
                },
                "strength" : {
                  "numerator" : {
                    "value" : 20,
                    "unit" : "mg"
                  },
                  "denominator" : {
                    "value" : 1,
                    "unit" : "Filmtbl."
                  }
                }
              }
            ]
          }
        }
      ]
    },
    {
      "name" : "empEntry",
      "resource" : {
        "resourceType" : "MedicationRequest",
        "id" : "881f3c6d-20e6-443e-b7dc-580a40fa3d14",
        "meta" : {
          "profile" : [
            "https://gematik.de/fhir/epa-medication/StructureDefinition/emp-medication-request|1.3.0"
          ]
        },
        "extension" : [
          {
            "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/context-extension",
            "valueCode" : "EMP"
          },
          {
            "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/reason-patient-instruction-extension",
            "valueString" : "Bluthochdruck"
          },
          {
            "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/patient-note-extension",
            "valueAnnotation" : {
              "text" : "Benazepril kann anfangs Schwindel verursachen - daher zuerst in Ruhe einnehmen und Autofahren vermeiden."
            }
          },
          {
            "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-MedicationRequest.effectiveDosePeriod",
            "valuePeriod" : {
              "start" : "2026-12-01"
            }
          },
          {
            "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/emp-origin-medication-extension",
            "valueReference" : {
              "reference" : "Medication/13c66845-d0ce-43e1-9b0b-884cbbe8df7f"
            }
          },
          {
            "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-MedicationRequest.renderedDosageInstruction",
            "valueMarkdown" : "1-0-1-0 Stück"
          },
          {
            "extension" : [
              {
                "url" : "algorithmVersion",
                "valueString" : "1.0.1"
              },
              {
                "url" : "language",
                "valueCode" : "de-DE"
              }
            ],
            "url" : "http://ig.fhir.de/igs/medication/StructureDefinition/GeneratedDosageInstructionsMeta"
          }
        ],
        "status" : "active",
        "intent" : "plan",
        "medicationReference" : {
          "reference" : "Medication/1193c409-3df4-4b55-b672-811665aaa1b7"
        },
        "subject" : {
          "identifier" : {
            "system" : "http://fhir.de/sid/gkv/kvid-10",
            "value" : "X110411319"
          }
        },
        "authoredOn" : "2026-12-01",
        "note" : [
          {
            "text" : "Hinweis für den LE"
          }
        ],
        "dosageInstruction" : [
          {
            "timing" : {
              "repeat" : {
                "frequency" : 2,
                "period" : 1,
                "periodUnit" : "d",
                "when" : ["MORN", "EVE"]
              }
            },
            "doseAndRate" : [
              {
                "doseQuantity" : {
                  "value" : 1,
                  "unit" : "Stück",
                  "system" : "https://fhir.kbv.de/CodeSystem/KBV_CS_SFHIR_BMP_DOSIEREINHEIT",
                  "code" : "1"
                }
              }
            ]
          }
        ]
      }
    }
  ]
}

```
