# Provide Prescription eRP - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **Provide Prescription eRP**

## OperationDefinition: Provide Prescription eRP 

| | |
| :--- | :--- |
| *Official URL*:https://gematik.de/fhir/epa-medication/OperationDefinition/provide-prescription-erp-OP | *Version*:1.3.0 |
| Active as of 2025-12-15 | *Computable Name*:providePrescription_MedicationSvc |
| **Copyright/Legal**: gematik GmbH / Dieser Implementation Guide ist lizenziert unter[Apache License](./license.md), Version 2.0. | |

 
The Provide Prescription eRP operation in the ePA MedicationService is used to add electronic prescriptions to a patient’s record. These prescriptions are already made by the E-Rezept-Fachdienst. This operation does not create new patient prescriptions; it just puts the ones made by the E-Rezept-Fachdienst into the patient’s ePA, making sure they are stored safely and can be easily accessed. 



## Resource Content

```json
{
  "resourceType" : "OperationDefinition",
  "id" : "provide-prescription-erp-OP",
  "meta" : {
    "profile" : [
      "https://gematik.de/fhir/ti/StructureDefinition/ti-operationdefinition"
    ]
  },
  "extension" : [
    {
      "url" : "https://gematik.de/fhir/ti/StructureDefinition/extension-http-method",
      "valueCode" : "POST"
    }
  ],
  "url" : "https://gematik.de/fhir/epa-medication/OperationDefinition/provide-prescription-erp-OP",
  "version" : "1.3.0",
  "name" : "providePrescription_MedicationSvc",
  "title" : "Provide Prescription eRP",
  "status" : "active",
  "kind" : "operation",
  "date" : "2025-12-15",
  "publisher" : "gematik GmbH",
  "contact" : [
    {
      "name" : "gematik GmbH",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.gematik.de"
        },
        {
          "system" : "email",
          "value" : "patientteam [ at ] gematik.de"
        }
      ]
    }
  ],
  "description" : "The Provide Prescription eRP operation in the ePA MedicationService is used to add electronic prescriptions to a patient's record. These prescriptions are already made by the E-Rezept-Fachdienst. This operation does not create new patient prescriptions; it just puts the ones made by the E-Rezept-Fachdienst into the patient's ePA, making sure they are stored safely and can be easily accessed.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "DE"
        }
      ]
    }
  ],
  "affectsState" : true,
  "code" : "provide-prescription-erp",
  "system" : true,
  "type" : false,
  "instance" : false,
  "inputProfile" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-op-provide-prescription-erp-input-parameters",
  "outputProfile" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-op-rx-prescription-erp-output-parameters"
}

```
