# eMP-Eintrag verknüpfen - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **eMP-Eintrag verknüpfen**

## OperationDefinition: eMP-Eintrag verknüpfen 

| | |
| :--- | :--- |
| *Official URL*:https://gematik.de/fhir/epa-medication/OperationDefinition/link-emp-op | *Version*:1.3.0 |
| Active as of 2025-12-15 | *Computable Name*:linkEMP_MedicationSvc |
| **Copyright/Legal**: gematik GmbH / Dieser Implementation Guide ist lizenziert unter[Apache License](./license.md), Version 2.0. | |

 
Diese Instanz-Operation dient der Verknüpfung eines bestehenden eML-Eintrags (MedicationStatement) mit einem bereits dokumentierten Eintrag im elektronischen Medikationsplan (eMP). 



## Resource Content

```json
{
  "resourceType" : "OperationDefinition",
  "id" : "link-emp-op",
  "meta" : {
    "profile" : [
      "https://gematik.de/fhir/ti/StructureDefinition/ti-operationdefinition"
    ]
  },
  "extension" : [
    {
      "url" : "https://gematik.de/fhir/ti/StructureDefinition/extension-http-method",
      "valueCode" : "POST"
    }
  ],
  "url" : "https://gematik.de/fhir/epa-medication/OperationDefinition/link-emp-op",
  "version" : "1.3.0",
  "name" : "linkEMP_MedicationSvc",
  "title" : "eMP-Eintrag verknüpfen",
  "status" : "active",
  "kind" : "operation",
  "date" : "2025-12-15",
  "publisher" : "gematik GmbH",
  "contact" : [
    {
      "name" : "gematik GmbH",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.gematik.de"
        },
        {
          "system" : "email",
          "value" : "patientteam [ at ] gematik.de"
        }
      ]
    }
  ],
  "description" : "Diese Instanz-Operation dient der Verknüpfung eines bestehenden eML-Eintrags (MedicationStatement) mit einem bereits dokumentierten Eintrag im elektronischen Medikationsplan (eMP).",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "DE"
        }
      ]
    }
  ],
  "affectsState" : true,
  "code" : "link-emp",
  "resource" : ["MedicationStatement"],
  "system" : false,
  "type" : false,
  "instance" : true,
  "inputProfile" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-op-link-emp-entry-parameters",
  "outputProfile" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-op-link-emp-entry-output-parameters"
}

```
