# Get Medication List - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **Get Medication List**

## OperationDefinition: Get Medication List 

| | |
| :--- | :--- |
| *Official URL*:https://gematik.de/fhir/epa-medication/OperationDefinition/get-medication-list-op | *Version*:1.3.0 |
| Active as of 2025-12-15 | *Computable Name*:getMedicationList_MedicationSvc |
| **Copyright/Legal**: gematik GmbH / Dieser Implementation Guide ist lizenziert unter[Apache License](./license.md), Version 2.0. | |

 
Die Operation liefert die elektronische Medikationsliste (eML) in Form eines FHIR searchSet-Bundles. In der eML werden ausschließlich nicht stornierte Instanzen von Verschreibungsdaten, Dispensierdaten, nachgetragenen Medikamenten sowie die zugehörige Versicherteninformation aus dem Patient Service angezeigt. 



## Resource Content

```json
{
  "resourceType" : "OperationDefinition",
  "id" : "get-medication-list-op",
  "meta" : {
    "profile" : [
      "https://gematik.de/fhir/ti/StructureDefinition/ti-operationdefinition"
    ]
  },
  "extension" : [
    {
      "url" : "https://gematik.de/fhir/ti/StructureDefinition/extension-http-method",
      "valueCode" : "GET"
    }
  ],
  "url" : "https://gematik.de/fhir/epa-medication/OperationDefinition/get-medication-list-op",
  "version" : "1.3.0",
  "name" : "getMedicationList_MedicationSvc",
  "title" : "Get Medication List",
  "status" : "active",
  "kind" : "operation",
  "date" : "2025-12-15",
  "publisher" : "gematik GmbH",
  "contact" : [
    {
      "name" : "gematik GmbH",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.gematik.de"
        },
        {
          "system" : "email",
          "value" : "patientteam [ at ] gematik.de"
        }
      ]
    }
  ],
  "description" : "Die Operation liefert die elektronische Medikationsliste (eML) in Form eines FHIR searchSet-Bundles. In der eML werden ausschließlich nicht stornierte Instanzen von Verschreibungsdaten, Dispensierdaten, nachgetragenen Medikamenten sowie die zugehörige Versicherteninformation aus dem Patient Service angezeigt.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "DE"
        }
      ]
    }
  ],
  "affectsState" : false,
  "code" : "medication-list",
  "system" : true,
  "type" : false,
  "instance" : false,
  "parameter" : [
    {
      "name" : "date",
      "use" : "in",
      "min" : 0,
      "max" : "2",
      "documentation" : "Limit the search to this date. Can specify upper or lower limits and periods by providing an upper and a lower limit.",
      "type" : "string",
      "searchType" : "date"
    },
    {
      "name" : "_count",
      "use" : "in",
      "min" : 0,
      "max" : "1",
      "documentation" : "Limit the result bundle to this many entries. To get more entries request the next page.",
      "type" : "string",
      "searchType" : "number"
    },
    {
      "name" : "_offset",
      "use" : "in",
      "min" : 0,
      "max" : "1",
      "documentation" : "Defines the offset of the first entry in the collection.",
      "type" : "string",
      "searchType" : "number"
    },
    {
      "name" : "return",
      "use" : "out",
      "min" : 1,
      "max" : "1",
      "documentation" : "Searchset bundle containing the requested entities.",
      "type" : "Bundle"
    }
  ]
}

```
