# eMP Commit Operation - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **eMP Commit Operation**

## OperationDefinition: eMP Commit Operation 

| | |
| :--- | :--- |
| *Official URL*:https://gematik.de/fhir/epa-medication/OperationDefinition/emp-commit-op | *Version*:1.3.0 |
| Active as of 2025-12-15 | *Computable Name*:eMPCommit_MedicationSvc |
| **Copyright/Legal**: gematik GmbH / Dieser Implementation Guide ist lizenziert unter[Apache License](./license.md), Version 2.0. | |

 
Die eMP Commit Operation dient zum Abschluss einer Batch-Verarbeitung von eMP-Einträgen.
Sie erzeugt eine neue Version des elektronischen Medikationsplans (eMP), indem eine aktualisierte
Instanz von EMPChronologyProvenance erstellt wird, die auf alle relevanten EMPMedicationRequest
verweist. Diese Operation wird in der Regel nur einmal am Ende eines Batch-Kontextes aufgerufen. 



## Resource Content

```json
{
  "resourceType" : "OperationDefinition",
  "id" : "emp-commit-op",
  "meta" : {
    "profile" : [
      "https://gematik.de/fhir/ti/StructureDefinition/ti-operationdefinition"
    ]
  },
  "extension" : [
    {
      "url" : "https://gematik.de/fhir/ti/StructureDefinition/extension-http-method",
      "valueCode" : "POST"
    }
  ],
  "url" : "https://gematik.de/fhir/epa-medication/OperationDefinition/emp-commit-op",
  "version" : "1.3.0",
  "name" : "eMPCommit_MedicationSvc",
  "title" : "eMP Commit Operation",
  "status" : "active",
  "kind" : "operation",
  "date" : "2025-12-15",
  "publisher" : "gematik GmbH",
  "contact" : [
    {
      "name" : "gematik GmbH",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.gematik.de"
        },
        {
          "system" : "email",
          "value" : "patientteam [ at ] gematik.de"
        }
      ]
    }
  ],
  "description" : "Die eMP Commit Operation dient zum Abschluss einer Batch-Verarbeitung von eMP-Einträgen.  \nSie erzeugt eine neue Version des elektronischen Medikationsplans (eMP), indem eine aktualisierte  \nInstanz von EMPChronologyProvenance erstellt wird, die auf alle relevanten EMPMedicationRequest  \nverweist. Diese Operation wird in der Regel nur einmal am Ende eines Batch-Kontextes aufgerufen.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "DE"
        }
      ]
    }
  ],
  "affectsState" : true,
  "code" : "emp-commit",
  "system" : true,
  "type" : false,
  "instance" : false,
  "inputProfile" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-op-rmp-commit-input-parameters",
  "parameter" : [
    {
      "name" : "return",
      "use" : "out",
      "min" : 1,
      "max" : "1",
      "type" : "Provenance"
    }
  ]
}

```
