# Cancel Prescription eRP - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **Cancel Prescription eRP**

## OperationDefinition: Cancel Prescription eRP 

| | |
| :--- | :--- |
| *Official URL*:https://gematik.de/fhir/epa-medication/OperationDefinition/cancel-prescription-erp-OP | *Version*:1.3.0 |
| Active as of 2025-12-15 | *Computable Name*:cancelPrescription_MedicationSvc |
| **Copyright/Legal**: gematik GmbH / Dieser Implementation Guide ist lizenziert unter[Apache License](./license.md), Version 2.0. | |

 
The $cancel-prescription-erp operation is used by the E-Rezept-Fachdienst to cancel an already issued electronic prescription. This function is applied when a prescription is no longer needed for various reasons, such as changes in medication or errors in the initial issuance. After cancellation by the E-Rezept-Fachdienst, this information is transmitted to the ePA Medication Service, where the prescription is calculations. It can then no longer be used for dispensing medication. This process ensures accuracy and safety in the management of medications. 



## Resource Content

```json
{
  "resourceType" : "OperationDefinition",
  "id" : "cancel-prescription-erp-OP",
  "meta" : {
    "profile" : [
      "https://gematik.de/fhir/ti/StructureDefinition/ti-operationdefinition"
    ]
  },
  "extension" : [
    {
      "url" : "https://gematik.de/fhir/ti/StructureDefinition/extension-http-method",
      "valueCode" : "POST"
    }
  ],
  "url" : "https://gematik.de/fhir/epa-medication/OperationDefinition/cancel-prescription-erp-OP",
  "version" : "1.3.0",
  "name" : "cancelPrescription_MedicationSvc",
  "title" : "Cancel Prescription eRP",
  "status" : "active",
  "kind" : "operation",
  "date" : "2025-12-15",
  "publisher" : "gematik GmbH",
  "contact" : [
    {
      "name" : "gematik GmbH",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.gematik.de"
        },
        {
          "system" : "email",
          "value" : "patientteam [ at ] gematik.de"
        }
      ]
    }
  ],
  "description" : "The $cancel-prescription-erp operation is used by the E-Rezept-Fachdienst to cancel an already issued electronic prescription. This function is applied when a prescription is no longer needed for various reasons, such as changes in medication or errors in the initial issuance. After cancellation by the E-Rezept-Fachdienst, this information is transmitted to the ePA Medication Service, where the prescription is calculations. It can then no longer be used for dispensing medication. This process ensures accuracy and safety in the management of medications.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "DE"
        }
      ]
    }
  ],
  "affectsState" : true,
  "code" : "cancel-prescription-erp",
  "system" : true,
  "type" : false,
  "instance" : false,
  "inputProfile" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-op-cancel-prescription-erp-input-parameters",
  "outputProfile" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-op-rx-prescription-erp-output-parameters"
}

```
