# Cancel Medication List Entry - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **Cancel Medication List Entry**

## OperationDefinition: Cancel Medication List Entry 

| | |
| :--- | :--- |
| *Official URL*:https://gematik.de/fhir/epa-medication/OperationDefinition/cancel-eml-entry-op | *Version*:1.3.0 |
| Active as of 2025-12-15 | *Computable Name*:cancelEMLEntry_MedicationSvc |
| **Copyright/Legal**: gematik GmbH / Dieser Implementation Guide ist lizenziert unter[Apache License](./license.md), Version 2.0. | |

 
Diese Operation dient dem gezielten Widerruf/Abbruch eines bestehenden Eintrags der elektronischen Medikationsliste (eML) auf Instanzebene. 



## Resource Content

```json
{
  "resourceType" : "OperationDefinition",
  "id" : "cancel-eml-entry-op",
  "meta" : {
    "profile" : [
      "https://gematik.de/fhir/ti/StructureDefinition/ti-operationdefinition"
    ]
  },
  "extension" : [
    {
      "url" : "https://gematik.de/fhir/ti/StructureDefinition/extension-http-method",
      "valueCode" : "POST"
    }
  ],
  "url" : "https://gematik.de/fhir/epa-medication/OperationDefinition/cancel-eml-entry-op",
  "version" : "1.3.0",
  "name" : "cancelEMLEntry_MedicationSvc",
  "title" : "Cancel Medication List Entry",
  "status" : "active",
  "kind" : "operation",
  "date" : "2025-12-15",
  "publisher" : "gematik GmbH",
  "contact" : [
    {
      "name" : "gematik GmbH",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.gematik.de"
        },
        {
          "system" : "email",
          "value" : "patientteam [ at ] gematik.de"
        }
      ]
    }
  ],
  "description" : "Diese Operation dient dem gezielten Widerruf/Abbruch eines bestehenden Eintrags der elektronischen Medikationsliste (eML) auf Instanzebene.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "DE"
        }
      ]
    }
  ],
  "affectsState" : true,
  "code" : "cancel-eml-entry",
  "resource" : ["MedicationStatement"],
  "system" : false,
  "type" : false,
  "instance" : true,
  "outputProfile" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-op-eml-entry-output-parameters"
}

```
