# Cancel Dispensation eRP - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **Cancel Dispensation eRP**

## OperationDefinition: Cancel Dispensation eRP 

| | |
| :--- | :--- |
| *Official URL*:https://gematik.de/fhir/epa-medication/OperationDefinition/cancel-dispensation-erp-OP | *Version*:1.3.0 |
| Active as of 2025-12-15 | *Computable Name*:cancelDispensation_MedicationSvc |
| **Copyright/Legal**: gematik GmbH / Dieser Implementation Guide ist lizenziert unter[Apache License](./license.md), Version 2.0. | |

 
The Cancel Dispensation eRP operation, used by the E-Rezept-Fachdienst, in the context of the ePA Medication Service, is applied to cancel or reverse information regarding the dispensation of a medication. This operation is necessary when a medication dispensation is cancelled by a pharmacist or when there is a return of the medication by the insurant. After the E-Rezept-Fachdienst performs this operation, the corresponding dispensation entry for the medication in the patient’s ePA is marked as cancelled, which the goal in ensuring an accurate and up-to-date record of the patient’s medication data. 



## Resource Content

```json
{
  "resourceType" : "OperationDefinition",
  "id" : "cancel-dispensation-erp-OP",
  "meta" : {
    "profile" : [
      "https://gematik.de/fhir/ti/StructureDefinition/ti-operationdefinition"
    ]
  },
  "extension" : [
    {
      "url" : "https://gematik.de/fhir/ti/StructureDefinition/extension-http-method",
      "valueCode" : "POST"
    }
  ],
  "url" : "https://gematik.de/fhir/epa-medication/OperationDefinition/cancel-dispensation-erp-OP",
  "version" : "1.3.0",
  "name" : "cancelDispensation_MedicationSvc",
  "title" : "Cancel Dispensation eRP",
  "status" : "active",
  "kind" : "operation",
  "date" : "2025-12-15",
  "publisher" : "gematik GmbH",
  "contact" : [
    {
      "name" : "gematik GmbH",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.gematik.de"
        },
        {
          "system" : "email",
          "value" : "patientteam [ at ] gematik.de"
        }
      ]
    }
  ],
  "description" : "The Cancel Dispensation eRP operation, used by the E-Rezept-Fachdienst, in the context of the ePA Medication Service, is applied to cancel or reverse information regarding the dispensation of a medication. This operation is necessary when a medication dispensation is cancelled by a pharmacist or when there is a return of the medication by the insurant. After the E-Rezept-Fachdienst performs this operation, the corresponding dispensation entry for the medication in the patient's ePA is marked as cancelled, which the goal in ensuring an accurate and up-to-date record of the patient's medication data.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "DE"
        }
      ]
    }
  ],
  "affectsState" : true,
  "code" : "cancel-dispensation-erp",
  "system" : true,
  "type" : false,
  "instance" : false,
  "inputProfile" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-op-cancel-dispensation-erp-input-parameters",
  "outputProfile" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-op-rx-dispensation-erp-output-parameters"
}

```
