# Batch eMP Einträge - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **Batch eMP Einträge**

## OperationDefinition: Batch eMP Einträge 

| | |
| :--- | :--- |
| *Official URL*:https://gematik.de/fhir/epa-medication/OperationDefinition/batch-emp-entries-op | *Version*:1.3.0 |
| Active as of 2025-12-15 | *Computable Name*:batchEMPEntries_MedicationSvc |
| **Copyright/Legal**: gematik GmbH / Dieser Implementation Guide ist lizenziert unter[Apache License](./license.md), Version 2.0. | |

 
Mit der Batch Operation $batch-emp können Primärsysteme mehrere fachliche Änderungen am eMP in einem Aufruf an den Medication Service übergeben. Innerhalb des Request-Bundles werden ausschließlich FHIR-Operationen ausgeführt (keine direkten Resource-CRUDs). Als letzte Operation ein $emp-commit ausgeführt, der eine neue Plan-Version (Provenance) erzeugt. Die Operation antwortet mit einem Bundle vom Typ transaction-response. 

 
Stapelverarbeitung von eMP-Änderungen mit konsistenter, atomarer Ausführung und anschließender Versionierung des eMP. Reduziert Roundtrips, vermeidet Zwischenzustände und stellt eine neue Plan-Version bereit. 



## Resource Content

```json
{
  "resourceType" : "OperationDefinition",
  "id" : "batch-emp-entries-op",
  "meta" : {
    "profile" : [
      "https://gematik.de/fhir/ti/StructureDefinition/ti-operationdefinition"
    ]
  },
  "extension" : [
    {
      "url" : "https://gematik.de/fhir/ti/StructureDefinition/extension-http-method",
      "valueCode" : "POST"
    }
  ],
  "url" : "https://gematik.de/fhir/epa-medication/OperationDefinition/batch-emp-entries-op",
  "version" : "1.3.0",
  "name" : "batchEMPEntries_MedicationSvc",
  "title" : "Batch eMP Einträge",
  "status" : "active",
  "kind" : "operation",
  "date" : "2025-12-15",
  "publisher" : "gematik GmbH",
  "contact" : [
    {
      "name" : "gematik GmbH",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.gematik.de"
        },
        {
          "system" : "email",
          "value" : "patientteam [ at ] gematik.de"
        }
      ]
    }
  ],
  "description" : "Mit der Batch Operation $batch-emp können Primärsysteme mehrere fachliche Änderungen am eMP in einem Aufruf\nan den Medication Service übergeben. Innerhalb des Request-Bundles werden ausschließlich FHIR-Operationen\nausgeführt (keine direkten Resource-CRUDs). Als letzte Operation ein $emp-commit ausgeführt, der eine neue\nPlan-Version (Provenance) erzeugt. Die Operation antwortet mit einem Bundle vom Typ transaction-response.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "DE"
        }
      ]
    }
  ],
  "purpose" : "Stapelverarbeitung von eMP-Änderungen mit konsistenter, atomarer Ausführung und anschließender\nVersionierung des eMP. Reduziert Roundtrips, vermeidet Zwischenzustände und stellt eine neue Plan-Version bereit.",
  "affectsState" : true,
  "code" : "batch-emp",
  "system" : true,
  "type" : false,
  "instance" : false,
  "parameter" : [
    {
      "name" : "resource",
      "use" : "in",
      "min" : 1,
      "max" : "1",
      "documentation" : "FHIR-Bundle vom Typ transaction gemäß des Profils gemäß EPABatchEmpRequestBundle.\nDie Ausführungssemantik ist serverseitig festgelegt. Verboten: direkte POST/PUT/DELETE auf Ressourcen außerhalb von Operationen.",
      "type" : "Bundle"
    },
    {
      "name" : "return",
      "use" : "out",
      "min" : 1,
      "max" : "1",
      "documentation" : "Antwort ist ein Bundle vom Typ transaction-response (bei atomarer Server-Policy. \nFür jeden Request-Entry enthält die Antwort einen korrespondierenden Entry mit:\n- response.status (HTTP-Status),\n- resource = Parameters (Ergebnisse von $add-emp-entry / $update-emp-entry),\n- beim letzten Eintrag ($emp-commit): eine Provenance-Instanz (neue eMP-Plan-Version).",
      "type" : "Bundle"
    }
  ]
}

```
