# eMP-Eintrag hinzufügen - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **eMP-Eintrag hinzufügen**

## OperationDefinition: eMP-Eintrag hinzufügen 

| | |
| :--- | :--- |
| *Official URL*:https://gematik.de/fhir/epa-medication/OperationDefinition/add-emp-entry-op | *Version*:1.3.0 |
| Active as of 2025-12-15 | *Computable Name*:addEMPEntry_MedicationSvc |
| **Copyright/Legal**: gematik GmbH / Dieser Implementation Guide ist lizenziert unter[Apache License](./license.md), Version 2.0. | |

 
Diese Operation ermöglicht das Hinzufügen eines neuen Medikations-Eintrags zum elektronischen Medikationsplan (eMP). Der Eintrag wird als EMPMedicationRequest erzeugt, wobei die angegebene Medication sowohl in medicationReference als auch in extension[originMedication] referenziert wird. 



## Resource Content

```json
{
  "resourceType" : "OperationDefinition",
  "id" : "add-emp-entry-op",
  "meta" : {
    "profile" : [
      "https://gematik.de/fhir/ti/StructureDefinition/ti-operationdefinition"
    ]
  },
  "extension" : [
    {
      "url" : "https://gematik.de/fhir/ti/StructureDefinition/extension-http-method",
      "valueCode" : "POST"
    }
  ],
  "url" : "https://gematik.de/fhir/epa-medication/OperationDefinition/add-emp-entry-op",
  "version" : "1.3.0",
  "name" : "addEMPEntry_MedicationSvc",
  "title" : "eMP-Eintrag hinzufügen",
  "status" : "active",
  "kind" : "operation",
  "date" : "2025-12-15",
  "publisher" : "gematik GmbH",
  "contact" : [
    {
      "name" : "gematik GmbH",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.gematik.de"
        },
        {
          "system" : "email",
          "value" : "patientteam [ at ] gematik.de"
        }
      ]
    }
  ],
  "description" : "Diese Operation ermöglicht das Hinzufügen eines neuen Medikations-Eintrags zum elektronischen Medikationsplan (eMP). Der Eintrag wird als EMPMedicationRequest erzeugt, wobei die angegebene Medication sowohl in medicationReference als auch in extension[originMedication] referenziert wird.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "DE"
        }
      ]
    }
  ],
  "affectsState" : true,
  "code" : "add-emp-entry",
  "system" : true,
  "type" : false,
  "instance" : false,
  "inputProfile" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-op-add-emp-entry-input-parameters",
  "outputProfile" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-op-emp-entry-output-parameters"
}

```
