# Sumatriptan_Information - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **Sumatriptan_Information**

## Example MedicationStatement: Sumatriptan_Information

version: 2; Last updated: 2026-11-01 15:43:33+0000

Profile: [EPA MedicationStatementversion: null1.3.0)](StructureDefinition-epa-medication-statement.md)

**RxPrescriptionProcessIdentifierExtension**: `https://gematik.de/fhir/epa-medication/sid/rx-prescription-process-identifier`/160.100.000.000.007.24_20261101

**ContextExtension**: PRESCRIPTION

**Extension Definition for MedicationStatement.renderedDosageInstruction for Version 5.0**: 

1-0-0-0 Stück

> **Generated Dosage Instructions Meta**
* algorithmVersion: 1.0.1
* language: de-DE

**basedOn**: [MedicationRequest: extension = EMP,akuten Behandlung von Migräneanfällen mit und ohne Aura,Bitte schützen Sie das Arzneimittel vor hohen Temperaturen und direkter Sonneneinstrahlung.,2026-12-01 --> 2027-02-01,->Medication 06313728,1-0-0-0 Stück,,; identifier = https://gematik.de/fhir/sid/emp-identifier#266620a9-2c26-41c1-b0cb-a10947b867f5; status = active; intent = plan; medication[x] = ->Medication 06313728; authoredOn = 2026-11-01; note = Hinweis für den LE](MedicationRequest-266620a9-2c26-41c1-b0cb-a10947b867f5.md)

**status**: Unknown

**medication**: [Medication 06313728](Medication-fc7b28e8-05ac-4ac8-86d7-7677d9c6134e.md)

**subject**: Identifier: NamingSystemKVID/X110411319

**effective**: 2025-11-01 --> (ongoing)

**dateAsserted**: 2026-11-01

**derivedFrom**: 

* [MedicationRequest: extension = ,1-0-0-0 Stück,; identifier = https://gematik.de/fhir/epa-medication/sid/rx-prescription-process-identifier#160.100.000.000.007.24_20250425,https://gematik.de/fhir/epa-medication/sid/rx-originator-process-identifier#5f4bc41c-480e-4ee4-b58e-a99268c1a1d0_160.100.000.000.007.24; status = active; intent = filler-order; medication[x] = ->Medication 06313728; authoredOn = 2026-11-01](MedicationRequest-4dd6f19d-002c-44ac-ae2f-3c9d08ad35b8.md)
* [MedicationDispense: extension = https://gematik.de/fhir/epa-medication/sid/rx-prescription-process-identifier#160.100.000.000.007.24_20261101; identifier = https://gematik.de/fhir/epa-medication/sid/rx-originator-process-identifier#1da91bd3-d5cb-459b-a270-32fad7d5d5d5_160.100.000.000.007.24; status = completed; medication[x] = ->Medication 06313728; whenHandedOver = 2026-11-01](MedicationDispense-fa0c29e1-c4e7-4f08-91ab-598a2233867c.md)

> **dosage****timing**: Morning, Once per 1 day

### DoseAndRates

| | |
| :--- | :--- |
| - | **Dose[x]** |
| * | 1 Stück(Details: KBV_CS_SFHIR_BMP_DOSIEREINHEIT code1 = '1') |




## Resource Content

```json
{
  "resourceType" : "MedicationStatement",
  "id" : "f29f1d0c-be05-4b0d-a335-3e508da39c0c",
  "meta" : {
    "versionId" : "2",
    "lastUpdated" : "2026-11-01T15:43:33.244Z",
    "profile" : [
      "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-statement|1.3.0"
    ]
  },
  "extension" : [
    {
      "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/rx-prescription-process-identifier-extension",
      "valueIdentifier" : {
        "system" : "https://gematik.de/fhir/epa-medication/sid/rx-prescription-process-identifier",
        "value" : "160.100.000.000.007.24_20261101"
      }
    },
    {
      "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/context-extension",
      "valueCode" : "PRESCRIPTION"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-MedicationStatement.renderedDosageInstruction",
      "valueMarkdown" : "1-0-0-0 Stück"
    },
    {
      "extension" : [
        {
          "url" : "algorithmVersion",
          "valueString" : "1.0.1"
        },
        {
          "url" : "language",
          "valueCode" : "de-DE"
        }
      ],
      "url" : "http://ig.fhir.de/igs/medication/StructureDefinition/GeneratedDosageInstructionsMeta"
    }
  ],
  "basedOn" : [
    {
      "extension" : [
        {
          "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/is-emp-extension",
          "valueBoolean" : true
        }
      ],
      "reference" : "MedicationRequest/266620a9-2c26-41c1-b0cb-a10947b867f5"
    }
  ],
  "status" : "unknown",
  "medicationReference" : {
    "reference" : "Medication/fc7b28e8-05ac-4ac8-86d7-7677d9c6134e"
  },
  "subject" : {
    "identifier" : {
      "system" : "http://fhir.de/sid/gkv/kvid-10",
      "value" : "X110411319"
    }
  },
  "effectivePeriod" : {
    "start" : "2025-11-01"
  },
  "dateAsserted" : "2026-11-01",
  "derivedFrom" : [
    {
      "reference" : "MedicationRequest/4dd6f19d-002c-44ac-ae2f-3c9d08ad35b8"
    },
    {
      "reference" : "MedicationDispense/fa0c29e1-c4e7-4f08-91ab-598a2233867c"
    }
  ],
  "dosage" : [
    {
      "timing" : {
        "repeat" : {
          "frequency" : 1,
          "period" : 1,
          "periodUnit" : "d",
          "when" : ["MORN"]
        }
      },
      "doseAndRate" : [
        {
          "doseQuantity" : {
            "value" : 1,
            "unit" : "Stück",
            "system" : "https://fhir.kbv.de/CodeSystem/KBV_CS_SFHIR_BMP_DOSIEREINHEIT",
            "code" : "1"
          }
        }
      ]
    }
  ]
}

```
