# Doxycyclin_Information - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **Doxycyclin_Information**

## Example MedicationStatement: Doxycyclin_Information

version: 2; Last updated: 2025-09-08 14:50:02+0000

Profile: [EPA MedicationStatementversion: null1.3.0)](StructureDefinition-epa-medication-statement.md)

**RxPrescriptionProcessIdentifierExtension**: `https://gematik.de/fhir/epa-medication/sid/rx-prescription-process-identifier`/160.100.000.000.011.09_20250906

**ContextExtension**: PRESCRIPTION

**Extension Definition for MedicationStatement.renderedDosageInstruction for Version 5.0**: 

1-0-0-0 Stück

> **Generated Dosage Instructions Meta**
* algorithmVersion: 1.0.1
* language: de-DE

**status**: Unknown

**medication**: [Medication 04773414](Medication-19549515-60a8-4e1c-b86a-49518053fe9f.md)

**subject**: Identifier: NamingSystemKVID/X110411319

**effective**: 2025-09-08 --> (ongoing)

**dateAsserted**: 2025-09-06

**derivedFrom**: 

* [MedicationRequest: extension = ,1-0-0-0 Stück,; identifier = https://gematik.de/fhir/epa-medication/sid/rx-prescription-process-identifier#160.100.000.000.011.09_20250906,https://gematik.de/fhir/epa-medication/sid/rx-originator-process-identifier#59b9fa64-4ca1-4bd2-8388-652d0fec32b2_160.100.000.000.011.09; status = completed; intent = filler-order; medication[x] = ->Medication 04773414; authoredOn = 2025-09-06](MedicationRequest-08cb8487-2758-406c-999a-e23a05e63c0b.md)
* [MedicationDispense: extension = https://gematik.de/fhir/epa-medication/sid/rx-prescription-process-identifier#160.100.000.000.011.09_20250906; identifier = https://gematik.de/fhir/epa-medication/sid/rx-originator-process-identifier#72f86151-cdb2-472c-8e98-e5ba71191e1d_160.100.000.000.011.09; status = completed; medication[x] = ->Medication 04773414; whenHandedOver = 2025-09-08](MedicationDispense-c3a353f0-c61a-4d6b-affa-daf8c0f6e77c.md)

> **dosage****timing**: Morning, Once per 1 day

### DoseAndRates

| | |
| :--- | :--- |
| - | **Dose[x]** |
| * | 1 Stück(Details: KBV_CS_SFHIR_BMP_DOSIEREINHEIT code1 = '1') |




## Resource Content

```json
{
  "resourceType" : "MedicationStatement",
  "id" : "405ff43e-bc8e-4109-b370-3e31431c5fe0",
  "meta" : {
    "versionId" : "2",
    "lastUpdated" : "2025-09-08T14:50:02.244Z",
    "profile" : [
      "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-statement|1.3.0"
    ]
  },
  "extension" : [
    {
      "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/rx-prescription-process-identifier-extension",
      "valueIdentifier" : {
        "system" : "https://gematik.de/fhir/epa-medication/sid/rx-prescription-process-identifier",
        "value" : "160.100.000.000.011.09_20250906"
      }
    },
    {
      "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/context-extension",
      "valueCode" : "PRESCRIPTION"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-MedicationStatement.renderedDosageInstruction",
      "valueMarkdown" : "1-0-0-0 Stück"
    },
    {
      "extension" : [
        {
          "url" : "algorithmVersion",
          "valueString" : "1.0.1"
        },
        {
          "url" : "language",
          "valueCode" : "de-DE"
        }
      ],
      "url" : "http://ig.fhir.de/igs/medication/StructureDefinition/GeneratedDosageInstructionsMeta"
    }
  ],
  "status" : "unknown",
  "medicationReference" : {
    "reference" : "Medication/19549515-60a8-4e1c-b86a-49518053fe9f"
  },
  "subject" : {
    "identifier" : {
      "system" : "http://fhir.de/sid/gkv/kvid-10",
      "value" : "X110411319"
    }
  },
  "effectivePeriod" : {
    "start" : "2025-09-08"
  },
  "dateAsserted" : "2025-09-06",
  "derivedFrom" : [
    {
      "reference" : "MedicationRequest/08cb8487-2758-406c-999a-e23a05e63c0b"
    },
    {
      "reference" : "MedicationDispense/c3a353f0-c61a-4d6b-affa-daf8c0f6e77c"
    }
  ],
  "dosage" : [
    {
      "timing" : {
        "repeat" : {
          "frequency" : 1,
          "period" : 1,
          "periodUnit" : "d",
          "when" : ["MORN"]
        }
      },
      "doseAndRate" : [
        {
          "doseQuantity" : {
            "value" : 1,
            "unit" : "Stück",
            "system" : "https://fhir.kbv.de/CodeSystem/KBV_CS_SFHIR_BMP_DOSIEREINHEIT",
            "code" : "1"
          }
        }
      ]
    }
  ]
}

```
