# Ramipril_Information - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **Ramipril_Information**

## Example MedicationStatement: Ramipril_Information

version: 2; Last updated: 2025-12-03 14:00:00+0000

Profile: [EPA MedicationStatementversion: null1.3.0)](StructureDefinition-epa-medication-statement.md)

**RxPrescriptionProcessIdentifierExtension**: `https://gematik.de/fhir/epa-medication/sid/rx-prescription-process-identifier`/160.100.000.000.019.82_20251202

**ContextExtension**: PRESCRIPTION

**Extension Definition for MedicationStatement.renderedDosageInstruction for Version 5.0**: 

1-0-0-0 Stück

> **Generated Dosage Instructions Meta**
* algorithmVersion: 1.0.1
* language: de-DE

**status**: Unknown

**medication**: [Medication: extension = https://gematik.de/fhir/epa-medication/sid/rx-prescription-process-identifier#160.100.000.000.019.82_20251202,Medicinal product (product) (SNOMED CT#763158003),Arzneimittel oder in die Arzneimittelversorgung nach § 31 SGB V einbezogenes Produkt (EPA Code System für Arzneimittelkategorien#00),N3,false; identifier = https://gematik.de/fhir/epa-medication/sid/epa-medication-unique-identifier#6E36794F8327D7B96B74DC7E29FFCB49CC2CD859EBB58251DC1FB4456BEF92A9,https://gematik.de/fhir/epa-medication/sid/rx-originator-process-identifier#48de03e7-84f3-4724-830e-5aabca10dfa8_160.100.000.000.019.82; status = active; form = ; amount = ? Stück / 1](Medication-3f0b0cb0-e8cf-4aaf-bad8-01a51619417b.md)

**subject**: Identifier: NamingSystemKVID/X110411319

**effective**: 2025-12-03 --> (ongoing)

**dateAsserted**: 2025-12-02

**derivedFrom**: 

* [MedicationRequest: extension = ,1-0-0-0 Stück,; identifier = https://gematik.de/fhir/epa-medication/sid/rx-prescription-process-identifier#160.100.000.000.019.82_20251202,https://gematik.de/fhir/epa-medication/sid/rx-originator-process-identifier#b7791120-8913-47d4-acd0-9ae633f6d6c0_160.100.000.000.019.82; status = completed; intent = filler-order; medication[x] = ->Medication: extension = https://gematik.de/fhir/epa-medication/sid/rx-prescription-process-identifier#160.100.000.000.019.82_20251202,Medicinal product (product) (SNOMED CT#763158003),Arzneimittel oder in die Arzneimittelversorgung nach § 31 SGB V einbezogenes Produkt (EPA Code System für Arzneimittelkategorien#00),N3,false; identifier = https://gematik.de/fhir/epa-medication/sid/epa-medication-unique-identifier#6E36794F8327D7B96B74DC7E29FFCB49CC2CD859EBB58251DC1FB4456BEF92A9,https://gematik.de/fhir/epa-medication/sid/rx-originator-process-identifier#48de03e7-84f3-4724-830e-5aabca10dfa8_160.100.000.000.019.82; status = active; form = ; amount = ? Stück / 1; authoredOn = 2025-12-02](MedicationRequest-0e7f16e4-d879-4a2c-8292-41c55201bbdd.md)
* [MedicationDispense: extension = https://gematik.de/fhir/epa-medication/sid/rx-prescription-process-identifier#160.100.000.000.019.82_20251202; identifier = https://gematik.de/fhir/epa-medication/sid/rx-originator-process-identifier#ad9696d3-bc6b-4033-bdd7-14b934dc4426_160.100.000.000.019.82; status = completed; medication[x] = ->Medication: extension = https://gematik.de/fhir/epa-medication/sid/rx-prescription-process-identifier#160.100.000.000.019.82_20251202,Medicinal product (product) (SNOMED CT#763158003),Arzneimittel oder in die Arzneimittelversorgung nach § 31 SGB V einbezogenes Produkt (EPA Code System für Arzneimittelkategorien#00),N3,false; identifier = https://gematik.de/fhir/epa-medication/sid/epa-medication-unique-identifier#6E36794F8327D7B96B74DC7E29FFCB49CC2CD859EBB58251DC1FB4456BEF92A9,https://gematik.de/fhir/epa-medication/sid/rx-originator-process-identifier#48de03e7-84f3-4724-830e-5aabca10dfa8_160.100.000.000.019.82; status = active; form = ; amount = ? Stück / 1; whenHandedOver = 2025-12-03](MedicationDispense-5aeaf266-a7ee-4e9d-bcb9-3c7dde96abad.md)

> **dosage****timing**: Morning, Once per 1 day

### DoseAndRates

| | |
| :--- | :--- |
| - | **Dose[x]** |
| * | 1 Stück(Details: KBV_CS_SFHIR_BMP_DOSIEREINHEIT code1 = '1') |




## Resource Content

```json
{
  "resourceType" : "MedicationStatement",
  "id" : "0fc1f006-5793-4501-81b6-fe3918fcfa2d",
  "meta" : {
    "versionId" : "2",
    "lastUpdated" : "2025-12-03T14:00:00.244Z",
    "profile" : [
      "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-statement|1.3.0"
    ]
  },
  "extension" : [
    {
      "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/rx-prescription-process-identifier-extension",
      "valueIdentifier" : {
        "system" : "https://gematik.de/fhir/epa-medication/sid/rx-prescription-process-identifier",
        "value" : "160.100.000.000.019.82_20251202"
      }
    },
    {
      "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/context-extension",
      "valueCode" : "PRESCRIPTION"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-MedicationStatement.renderedDosageInstruction",
      "valueMarkdown" : "1-0-0-0 Stück"
    },
    {
      "extension" : [
        {
          "url" : "algorithmVersion",
          "valueString" : "1.0.1"
        },
        {
          "url" : "language",
          "valueCode" : "de-DE"
        }
      ],
      "url" : "http://ig.fhir.de/igs/medication/StructureDefinition/GeneratedDosageInstructionsMeta"
    }
  ],
  "status" : "unknown",
  "medicationReference" : {
    "reference" : "Medication/3f0b0cb0-e8cf-4aaf-bad8-01a51619417b"
  },
  "subject" : {
    "identifier" : {
      "system" : "http://fhir.de/sid/gkv/kvid-10",
      "value" : "X110411319"
    }
  },
  "effectivePeriod" : {
    "start" : "2025-12-03"
  },
  "dateAsserted" : "2025-12-02",
  "derivedFrom" : [
    {
      "reference" : "MedicationRequest/0e7f16e4-d879-4a2c-8292-41c55201bbdd"
    },
    {
      "reference" : "MedicationDispense/5aeaf266-a7ee-4e9d-bcb9-3c7dde96abad"
    }
  ],
  "dosage" : [
    {
      "timing" : {
        "repeat" : {
          "frequency" : 1,
          "period" : 1,
          "periodUnit" : "d",
          "when" : ["MORN"]
        }
      },
      "doseAndRate" : [
        {
          "doseQuantity" : {
            "value" : 1,
            "unit" : "Stück",
            "system" : "https://fhir.kbv.de/CodeSystem/KBV_CS_SFHIR_BMP_DOSIEREINHEIT",
            "code" : "1"
          }
        }
      ]
    }
  ]
}

```
