# COTRIM_Request - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **COTRIM_Request**

## Example MedicationRequest: COTRIM_Request



## Resource Content

```json
{
  "resourceType" : "MedicationRequest",
  "id" : "f14498f0-4932-490a-91a2-9de8616e133b",
  "meta" : {
    "versionId" : "2",
    "lastUpdated" : "2025-10-19T14:43:33.244Z",
    "profile" : [
      "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-request|1.3.0"
    ]
  },
  "extension" : [
    {
      "extension" : [
        {
          "url" : "indicator",
          "valueBoolean" : false
        }
      ],
      "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/multiple-prescription-extension"
    }
  ],
  "identifier" : [
    {
      "system" : "https://gematik.de/fhir/epa-medication/sid/rx-prescription-process-identifier",
      "value" : "160.112.925.848.156.74_20251019"
    },
    {
      "system" : "https://gematik.de/fhir/epa-medication/sid/rx-originator-process-identifier",
      "value" : "0313be88-4c73-40e6-aa44-a7ed3de1a77a_160.112.925.848.156.74"
    }
  ],
  "status" : "completed",
  "intent" : "filler-order",
  "medicationReference" : {
    "reference" : "Medication/1254591a-dd2d-4d17-b8f8-ee3155da0699"
  },
  "subject" : {
    "identifier" : {
      "system" : "http://fhir.de/sid/gkv/kvid-10",
      "value" : "X110411319"
    }
  },
  "authoredOn" : "2025-10-19",
  "requester" : {
    "reference" : "PractitionerRole/73a551f8-d8cd-4b44-823d-ab5f8aeab1aa"
  },
  "basedOn" : [
    {
      "identifier" : {
        "system" : "https://gematik.de/fhir/sid/emp-identifier",
        "value" : "00000000-0000-0000-0000-000000000000"
      }
    }
  ],
  "dosageInstruction" : [
    {
      "text" : "morgens und abends 1 Messlöffel"
    }
  ],
  "dispenseRequest" : {
    "quantity" : {
      "value" : 1,
      "unit" : "Packung"
    }
  },
  "substitution" : {
    "allowedBoolean" : true
  }
}

```
