# Sumatriptan_Request - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **Sumatriptan_Request**

## Example MedicationRequest: Sumatriptan_Request



## Resource Content

```json
{
  "resourceType" : "MedicationRequest",
  "id" : "4dd6f19d-002c-44ac-ae2f-3c9d08ad35b8",
  "meta" : {
    "versionId" : "2",
    "lastUpdated" : "2026-11-01T14:43:33.244Z",
    "profile" : [
      "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-request|1.3.0"
    ]
  },
  "extension" : [
    {
      "extension" : [
        {
          "url" : "indicator",
          "valueBoolean" : false
        }
      ],
      "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/multiple-prescription-extension"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-MedicationRequest.renderedDosageInstruction",
      "valueMarkdown" : "1-0-0-0 Stück"
    },
    {
      "extension" : [
        {
          "url" : "algorithmVersion",
          "valueString" : "1.0.1"
        },
        {
          "url" : "language",
          "valueCode" : "de-DE"
        }
      ],
      "url" : "http://ig.fhir.de/igs/medication/StructureDefinition/GeneratedDosageInstructionsMeta"
    }
  ],
  "identifier" : [
    {
      "system" : "https://gematik.de/fhir/epa-medication/sid/rx-prescription-process-identifier",
      "value" : "160.100.000.000.007.24_20250425"
    },
    {
      "system" : "https://gematik.de/fhir/epa-medication/sid/rx-originator-process-identifier",
      "value" : "5f4bc41c-480e-4ee4-b58e-a99268c1a1d0_160.100.000.000.007.24"
    }
  ],
  "status" : "active",
  "intent" : "filler-order",
  "medicationReference" : {
    "reference" : "Medication/fc7b28e8-05ac-4ac8-86d7-7677d9c6134e"
  },
  "subject" : {
    "identifier" : {
      "system" : "http://fhir.de/sid/gkv/kvid-10",
      "value" : "X110411319"
    }
  },
  "authoredOn" : "2026-11-01",
  "requester" : {
    "reference" : "PractitionerRole/b9eb9668-b61e-43b5-b3ea-485234836d59"
  },
  "basedOn" : [
    {
      "identifier" : {
        "system" : "https://gematik.de/fhir/sid/emp-identifier",
        "value" : "4dd6f19d-002c-44ac-ae2f-3c9d08ad35b8"
      }
    }
  ],
  "dosageInstruction" : [
    {
      "timing" : {
        "repeat" : {
          "frequency" : 1,
          "period" : 1,
          "periodUnit" : "d",
          "when" : ["MORN"]
        }
      },
      "doseAndRate" : [
        {
          "doseQuantity" : {
            "value" : 1,
            "unit" : "Stück",
            "system" : "https://fhir.kbv.de/CodeSystem/KBV_CS_SFHIR_BMP_DOSIEREINHEIT",
            "code" : "1"
          }
        }
      ]
    }
  ],
  "dispenseRequest" : {
    "quantity" : {
      "value" : 1,
      "system" : "http://unitsofmeasure.org",
      "code" : "{Package}"
    }
  },
  "substitution" : {
    "allowedBoolean" : true
  }
}

```
