# L-Thyroxin_Dispense_MV_1 - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **L-Thyroxin_Dispense_MV_1**

## Example MedicationDispense: L-Thyroxin_Dispense_MV_1



## Resource Content

```json
{
  "resourceType" : "MedicationDispense",
  "id" : "f7240e05-01a1-4ce6-a8bb-edb71b6b5104",
  "meta" : {
    "versionId" : "1",
    "lastUpdated" : "2025-10-29T14:44:00.244Z",
    "profile" : [
      "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-dispense|1.3.0"
    ]
  },
  "extension" : [
    {
      "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/rx-prescription-process-identifier-extension",
      "valueIdentifier" : {
        "system" : "https://gematik.de/fhir/epa-medication/sid/rx-prescription-process-identifier",
        "value" : "160.100.000.000.010.12_20251027"
      }
    }
  ],
  "identifier" : [
    {
      "system" : "https://gematik.de/fhir/epa-medication/sid/rx-originator-process-identifier",
      "value" : "3a534e48-80e8-4bbb-a19e-43e83d6f3a3e_160.100.000.000.010.12"
    }
  ],
  "status" : "completed",
  "medicationReference" : {
    "reference" : "Medication/deecd514-235d-41df-a664-e3672208f410"
  },
  "subject" : {
    "identifier" : {
      "system" : "http://fhir.de/sid/gkv/kvid-10",
      "value" : "X110411319"
    }
  },
  "performer" : [
    {
      "actor" : {
        "reference" : "Organization/151f1697-7512-4e21-9466-1b75207475d8",
        "identifier" : {
          "type" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                "code" : "PRN",
                "display" : "Provider number"
              }
            ]
          },
          "system" : "https://gematik.de/fhir/sid/telematik-id",
          "value" : "9-2.58.00000023"
        },
        "display" : "gematik Apotheke"
      }
    }
  ],
  "authorizingPrescription" : [
    {
      "reference" : "MedicationRequest/ed2eeb8c-9ab6-4f4f-be9d-7e1a3784045e"
    }
  ],
  "quantity" : {
    "value" : 1,
    "unit" : "Packung"
  },
  "whenHandedOver" : "2025-10-29",
  "substitution" : {
    "wasSubstituted" : false
  }
}

```
