# Doxycyclin_Dispense - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **Doxycyclin_Dispense**

## Example MedicationDispense: Doxycyclin_Dispense



## Resource Content

```json
{
  "resourceType" : "MedicationDispense",
  "id" : "c3a353f0-c61a-4d6b-affa-daf8c0f6e77c",
  "meta" : {
    "versionId" : "1",
    "lastUpdated" : "2025-09-08T14:50:02.244Z",
    "profile" : [
      "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-dispense|1.3.0"
    ]
  },
  "extension" : [
    {
      "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/rx-prescription-process-identifier-extension",
      "valueIdentifier" : {
        "system" : "https://gematik.de/fhir/epa-medication/sid/rx-prescription-process-identifier",
        "value" : "160.100.000.000.011.09_20250906"
      }
    }
  ],
  "identifier" : [
    {
      "system" : "https://gematik.de/fhir/epa-medication/sid/rx-originator-process-identifier",
      "value" : "72f86151-cdb2-472c-8e98-e5ba71191e1d_160.100.000.000.011.09"
    }
  ],
  "status" : "completed",
  "medicationReference" : {
    "reference" : "Medication/19549515-60a8-4e1c-b86a-49518053fe9f"
  },
  "subject" : {
    "identifier" : {
      "system" : "http://fhir.de/sid/gkv/kvid-10",
      "value" : "X110411319"
    }
  },
  "performer" : [
    {
      "actor" : {
        "reference" : "Organization/151f1697-7512-4e21-9466-1b75207475d8",
        "identifier" : {
          "type" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                "code" : "PRN",
                "display" : "Provider number"
              }
            ]
          },
          "system" : "https://gematik.de/fhir/sid/telematik-id",
          "value" : "9-2.58.00000023"
        },
        "display" : "gematik Apotheke"
      }
    }
  ],
  "authorizingPrescription" : [
    {
      "reference" : "MedicationRequest/08cb8487-2758-406c-999a-e23a05e63c0b"
    }
  ],
  "whenHandedOver" : "2025-09-08",
  "substitution" : {
    "wasSubstituted" : false
  }
}

```
