# Prospan - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **Prospan**

## Example Medication: Prospan



## Resource Content

```json
{
  "resourceType" : "Medication",
  "id" : "ab8addbd-c4c7-48d2-bf4b-4a7c99f9fd6e",
  "meta" : {
    "versionId" : "2",
    "lastUpdated" : "2025-11-27T14:43:40.244Z",
    "profile" : [
      "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication|1.3.0"
    ]
  },
  "extension" : [
    {
      "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/rx-prescription-process-identifier-extension",
      "valueIdentifier" : {
        "system" : "https://gematik.de/fhir/epa-medication/sid/rx-prescription-process-identifier",
        "value" : "160.100.000.000.002.36_20251127"
      }
    },
    {
      "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-type-extension",
      "valueCoding" : {
        "system" : "http://snomed.info/sct",
        "code" : "763158003",
        "display" : "Medicinal product (product)"
      }
    },
    {
      "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/drug-category-extension",
      "valueCoding" : {
        "system" : "https://gematik.de/fhir/epa-medication/CodeSystem/epa-drug-category-cs",
        "code" : "00"
      }
    },
    {
      "url" : "http://fhir.de/StructureDefinition/normgroesse",
      "valueCode" : "N1"
    }
  ],
  "identifier" : [
    {
      "system" : "https://gematik.de/fhir/epa-medication/sid/epa-medication-unique-identifier",
      "value" : "1AAF4C0C8407A152A3C41728DB3DE4BBC363CD4CE6B8A2537E1CEF61DA4065ED"
    },
    {
      "system" : "https://gematik.de/fhir/epa-medication/sid/rx-originator-process-identifier",
      "value" : "4ef3e77d-fcaf-483e-8c65-c09372bb60fe_160.100.000.000.002.36"
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://fhir.de/CodeSystem/ifa/pzn",
        "code" : "08585997"
      }
    ],
    "text" : "Prospan® Hustensaft 100ml N1"
  },
  "status" : "active",
  "form" : {
    "coding" : [
      {
        "system" : "https://fhir.kbv.de/CodeSystem/KBV_CS_SFHIR_KBV_DARREICHUNGSFORM",
        "code" : "FLE"
      }
    ]
  },
  "ingredient" : [
    {
      "itemCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://fhir.de/CodeSystem/ask",
            "code" : "50912"
          }
        ],
        "text" : "Efeublätter-Trockenextrakt (5-7,5:1); Auszugsmittel: Ethanol 30% (m/m)"
      },
      "strength" : {
        "numerator" : {
          "value" : 35,
          "unit" : "mg"
        },
        "denominator" : {
          "value" : 5,
          "unit" : "ml"
        }
      }
    }
  ]
}

```
