# Technical-Exp-EPAMedicationMax - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **Technical-Exp-EPAMedicationMax**

## Example Medication: Technical-Exp-EPAMedicationMax

Das bereitgestellte Beispiel dient ausschließlich als technische Illustration und soll darstellen, wie Elemente befüllt werden könnten oder wie verschiedene Instanzen zusammenhängen und hat keinen Anspruch daran, fachlich korrekt oder sinnvoll zu sein.



## Resource Content

```json
{
  "resourceType" : "Medication",
  "id" : "Technical-Exp-EPAMedicationMax",
  "meta" : {
    "versionId" : "1",
    "lastUpdated" : "2023-02-03T11:30:00+01:00",
    "profile" : [
      "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication|1.3.0"
    ]
  },
  "extension" : [
    {
      "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-type-extension",
      "valueCoding" : {
        "system" : "http://snomed.info/sct",
        "code" : "373873005",
        "display" : "Pharmaceutical / biologic product (product)"
      }
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://fhir.de/CodeSystem/ifa/pzn",
        "code" : "9717395",
        "display" : "Maaloxan® 25 mVal Sodbrennen Kautabletten Lemon"
      },
      {
        "system" : "http://fhir.de/CodeSystem/bfarm/atc",
        "version" : "2024",
        "code" : "A02AD10",
        "display" : "Aluminiumoxid in Kombination mit Magnesiumhydroxid"
      },
      {
        "system" : "http://fhir.de/CodeSystem/ask",
        "code" : "02250",
        "display" : "Magnesiumhydroxid"
      }
    ],
    "text" : "Maaloxan® 25 mVal Sodbrennen Kautabletten Lemon"
  },
  "status" : "active",
  "manufacturer" : {
    "display" : "Praxis Dr. med. Hans Topp-Glücklich"
  },
  "form" : {
    "coding" : [
      {
        "system" : "https://fhir.kbv.de/CodeSystem/KBV_CS_SFHIR_KBV_DARREICHUNGSFORM",
        "code" : "KTA",
        "display" : "Kautabletten"
      }
    ]
  },
  "amount" : {
    "numerator" : {
      "value" : 30,
      "unit" : "Tabletten",
      "system" : "http://unitsofmeasure.org",
      "code" : "{Tabletten}"
    },
    "denominator" : {
      "value" : 1,
      "unit" : "Package",
      "system" : "http://unitsofmeasure.org",
      "code" : "{Package}"
    }
  },
  "ingredient" : [
    {
      "itemCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://fhir.de/CodeSystem/ask",
            "code" : "2250",
            "display" : "Magnesiumhydroxid"
          },
          {
            "system" : "http://fhir.de/CodeSystem/bfarm/atc",
            "version" : "2024",
            "code" : "A02AA04",
            "display" : "Magnesiumhydroxid"
          }
        ]
      },
      "strength" : {
        "numerator" : {
          "value" : 400,
          "unit" : "milligramm",
          "system" : "http://unitsofmeasure.org",
          "code" : "mg"
        },
        "denominator" : {
          "value" : 1,
          "unit" : "Tabletten",
          "system" : "http://unitsofmeasure.org",
          "code" : "{Tabletten}"
        }
      }
    },
    {
      "itemCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://fhir.de/CodeSystem/ask",
            "code" : "01253",
            "display" : "Algeldrat"
          },
          {
            "system" : "http://fhir.de/CodeSystem/bfarm/atc",
            "version" : "2024",
            "code" : "A02AB01",
            "display" : "Aluminiumhydroxid"
          }
        ]
      },
      "strength" : {
        "numerator" : {
          "value" : 400,
          "unit" : "milligramm",
          "system" : "http://unitsofmeasure.org",
          "code" : "mg"
        },
        "denominator" : {
          "value" : 1,
          "unit" : "Tabletten",
          "system" : "http://unitsofmeasure.org",
          "code" : "{Tabletten}"
        }
      }
    }
  ]
}

```
