# Cortison Dexpantenol Medication - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **Cortison Dexpantenol Medication**

## Example Medication: Cortison Dexpantenol Medication

Das bereitgestellte Beispiel dient ausschließlich als technische Illustration und soll darstellen, wie Elemente befüllt werden könnten oder wie verschiedene Instanzen zusammenhängen und hat keinen Anspruch daran, fachlich korrekt oder sinnvoll zu sein.



## Resource Content

```json
{
  "resourceType" : "Medication",
  "id" : "CortisonDexpantenol",
  "meta" : {
    "profile" : [
      "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication|1.3.0"
    ]
  },
  "contained" : [
    {
      "resourceType" : "Medication",
      "id" : "Contained-Hydrocortison",
      "meta" : {
        "profile" : [
          "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-pzn-ingredient|1.0.6-2"
        ]
      },
      "extension" : [
        {
          "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-type-extension",
          "valueCoding" : {
            "system" : "http://snomed.info/sct",
            "code" : "781405001",
            "display" : "Medicinal product package (product)"
          }
        }
      ],
      "code" : {
        "coding" : [
          {
            "system" : "http://fhir.de/CodeSystem/ifa/pzn",
            "code" : "03424249",
            "display" : "Hydrocortison 1% Creme"
          }
        ],
        "text" : "Hydrocortison 1% Creme"
      }
    },
    {
      "resourceType" : "Medication",
      "id" : "Contained-Dexpanthenol",
      "meta" : {
        "profile" : [
          "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-pzn-ingredient|1.0.6-2"
        ]
      },
      "extension" : [
        {
          "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-type-extension",
          "valueCoding" : {
            "system" : "http://snomed.info/sct",
            "code" : "781405001",
            "display" : "Medicinal product package (product)"
          }
        }
      ],
      "code" : {
        "coding" : [
          {
            "system" : "http://fhir.de/CodeSystem/ifa/pzn",
            "code" : "16667195",
            "display" : "Dexpanthenol 5% Creme"
          }
        ],
        "text" : "Dexpanthenol 5% Creme"
      }
    }
  ],
  "extension" : [
    {
      "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/drug-category-extension",
      "valueCoding" : {
        "system" : "https://gematik.de/fhir/epa-medication/CodeSystem/epa-drug-category-cs",
        "code" : "00"
      }
    },
    {
      "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-type-extension",
      "valueCoding" : {
        "system" : "http://snomed.info/sct",
        "code" : "1208954007",
        "display" : "Extemporaneous preparation (product)"
      }
    },
    {
      "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/medication-id-vaccine-extension",
      "valueBoolean" : false
    }
  ],
  "identifier" : [
    {
      "system" : "https://gematik.de/fhir/epa-medication/sid/epa-medication-unique-identifier",
      "value" : "570106FB94760C468D4431074523DDC3CC128385EB7F506FAB12F811790C15A9"
    }
  ],
  "code" : {
    "text" : "Hydrocortison-Dexpanthenol-Salbe"
  },
  "form" : {
    "coding" : [
      {
        "system" : "https://fhir.kbv.de/CodeSystem/KBV_CS_SFHIR_KBV_DARREICHUNGSFORM",
        "code" : "SAL"
      }
    ]
  },
  "ingredient" : [
    {
      "itemReference" : {
        "reference" : "#Contained-Hydrocortison"
      },
      "isActive" : true,
      "strength" : {
        "numerator" : {
          "value" : 50,
          "system" : "http://unitsofmeasure.org",
          "code" : "g"
        },
        "denominator" : {
          "value" : 100,
          "system" : "http://unitsofmeasure.org",
          "code" : "g"
        }
      }
    },
    {
      "itemReference" : {
        "reference" : "#Contained-Dexpanthenol"
      },
      "isActive" : true,
      "strength" : {
        "numerator" : {
          "value" : 50,
          "system" : "http://unitsofmeasure.org",
          "code" : "g"
        },
        "denominator" : {
          "value" : 100,
          "system" : "http://unitsofmeasure.org",
          "code" : "g"
        }
      }
    }
  ]
}

```
