# Diclo - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **Diclo**

## Example Medication: Diclo



## Resource Content

```json
{
  "resourceType" : "Medication",
  "id" : "2571d29b-e213-40ec-b817-a1490718f491",
  "meta" : {
    "versionId" : "1",
    "lastUpdated" : "2026-02-22T14:43:33.244Z",
    "profile" : [
      "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication|1.3.0"
    ]
  },
  "extension" : [
    {
      "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-type-extension",
      "valueCoding" : {
        "system" : "http://snomed.info/sct",
        "code" : "781405001",
        "display" : "Medicinal product package (product)"
      }
    },
    {
      "url" : "http://fhir.de/StructureDefinition/normgroesse",
      "valueCode" : "N1"
    }
  ],
  "identifier" : [
    {
      "system" : "https://gematik.de/fhir/epa-medication/sid/epa-medication-unique-identifier",
      "value" : "B849184C973EA5FA7D9751E6FAA6AFCFFD100183596239F84DD2C0FG4C751D67"
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://fhir.de/CodeSystem/ifa/pzn",
        "code" : "14170042",
        "display" : "Diclo-ratiopharm® bei Schmerzen und Fieber 25 mg Filmtabletten"
      }
    ],
    "text" : "Diclo-ratiopharm® bei Schmerzen und Fieber 25 mg Filmtabletten"
  },
  "status" : "active",
  "form" : {
    "coding" : [
      {
        "system" : "https://fhir.kbv.de/CodeSystem/KBV_CS_SFHIR_KBV_DARREICHUNGSFORM",
        "code" : "TAB"
      }
    ]
  },
  "amount" : {
    "numerator" : {
      "extension" : [
        {
          "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/medication-total-quantity-formulation-extension",
          "valueString" : "20 St."
        }
      ],
      "value" : 20,
      "unit" : "St"
    },
    "denominator" : {
      "value" : 1
    }
  }
}

```
