# EPA MedicationStatement Processing Codes - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **EPA MedicationStatement Processing Codes**

## CodeSystem: EPA MedicationStatement Processing Codes 

| | |
| :--- | :--- |
| *Official URL*:https://gematik.de/fhir/epa-medication/CodeSystem/epa-medicationstatement-processing-event-code | *Version*:1.3.0 |
| Active as of 2025-12-15 | *Computable Name*:EPAMedicationStatementProcessingEventCodeCS |
| **Copyright/Legal**: gematik GmbH / Dieses Artefakt ist lizenziert unter[Apache License](./license.md), Version 2.0. | |

 
Codes that define events that occur during processing of an EMPMedicationStatement 

 This Code system is referenced in the content logical definition of the following value sets: 

* [EPAMedicationStatementProcessingEventCodeVS](ValueSet-epa-medicationstatement-processing-event-code.md)
* [EPAMSOperationOutcomeDetailsVS](ValueSet-epa-ms-operation-outcome-details.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "epa-medicationstatement-processing-event-code",
  "url" : "https://gematik.de/fhir/epa-medication/CodeSystem/epa-medicationstatement-processing-event-code",
  "version" : "1.3.0",
  "name" : "EPAMedicationStatementProcessingEventCodeCS",
  "title" : "EPA MedicationStatement Processing Codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-15",
  "publisher" : "gematik GmbH",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.gematik.de"
        }
      ]
    }
  ],
  "description" : "Codes that define events that occur during processing of an EMPMedicationStatement",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "DE"
        }
      ]
    }
  ],
  "copyright" : "gematik GmbH / Dieses Artefakt ist lizenziert unter [Apache License](./license.html), Version 2.0.",
  "caseSensitive" : true,
  "content" : "complete",
  "count" : 2,
  "concept" : [
    {
      "code" : "LINKING_NOT_SUCCESSFUL",
      "display" : "eMP linking not successful",
      "definition" : "MedicationStatement could not be linked to an eMP-Entry successfully",
      "designation" : [
        {
          "language" : "de-DE",
          "value" : "Fehlerhafte eMP Zuordnung"
        }
      ]
    },
    {
      "code" : "UNLINKING_NOT_SUCCESSFUL",
      "display" : "eMP unlinking not successful",
      "definition" : "MedicationStatement could not be unlinked from an eMP-Entry successfully",
      "designation" : [
        {
          "language" : "de-DE",
          "value" : "Fehlerhafte Aufhebung der eMP-Verknüpfung"
        }
      ]
    }
  ]
}

```
