# Context Codes - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **Context Codes**

## CodeSystem: Context Codes 

| | |
| :--- | :--- |
| *Official URL*:https://gematik.de/fhir/epa-medication/CodeSystem/context-code | *Version*:1.3.0 |
| Active as of 2025-12-15 | *Computable Name*:ContextCodeCS |
| **Copyright/Legal**: gematik GmbH / Dieses Artefakt ist lizenziert unter[Apache License](./license.md), Version 2.0. | |

 
Codes that define the context of a resource instance in the ePA context 

 This Code system is referenced in the content logical definition of the following value sets: 

* [ContextCodeVS](ValueSet-context-code.md)
* [EPAMedicationStatementContextCodeVS](ValueSet-epa-medicationstatement-context-code.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "context-code",
  "url" : "https://gematik.de/fhir/epa-medication/CodeSystem/context-code",
  "version" : "1.3.0",
  "name" : "ContextCodeCS",
  "title" : "Context Codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-15",
  "publisher" : "gematik GmbH",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.gematik.de"
        }
      ]
    }
  ],
  "description" : "Codes that define the context of a resource instance in the ePA context",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "DE"
        }
      ]
    }
  ],
  "copyright" : "gematik GmbH / Dieses Artefakt ist lizenziert unter [Apache License](./license.html), Version 2.0.",
  "caseSensitive" : true,
  "valueSet" : "https://gematik.de/fhir/epa-medication/ValueSet/context-code",
  "content" : "complete",
  "count" : 3,
  "concept" : [
    {
      "code" : "PRESCRIPTION",
      "display" : "Prescription",
      "definition" : "Belongs to ePrescription process",
      "designation" : [
        {
          "language" : "de-DE",
          "value" : "Verschreibung"
        }
      ]
    },
    {
      "code" : "MANUAL",
      "display" : "Manual Entry",
      "definition" : "Is a manual entry",
      "designation" : [
        {
          "language" : "de-DE",
          "value" : "Nachtrag"
        }
      ]
    },
    {
      "code" : "EMP",
      "display" : "eMP",
      "definition" : "Electronic medication plan",
      "designation" : [
        {
          "language" : "de-DE",
          "value" : "eMP"
        }
      ]
    }
  ]
}

```
