# ExampleSearchsetBundleEPAMedicationRequest - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **ExampleSearchsetBundleEPAMedicationRequest**

## Example Bundle: ExampleSearchsetBundleEPAMedicationRequest

Das bereitgestellte Beispiel dient ausschließlich als technische Illustration und soll darstellen, wie Elemente befüllt werden könnten oder wie verschiedene Instanzen zusammenhängen und hat keinen Anspruch daran, fachlich korrekt oder sinnvoll zu sein.



## Resource Content

```json
{
  "resourceType" : "Bundle",
  "id" : "example-searchset-medicationrequest",
  "type" : "searchset",
  "total" : 100,
  "link" : [
    {
      "relation" : "self",
      "url" : "/epa/medication/api/v1/fhir/MedicationRequest?_offset=20&_count=10"
    },
    {
      "relation" : "previous",
      "url" : "/epa/medication/api/v1/fhir/MedicationRequest?_offset=10&_count=10"
    },
    {
      "relation" : "next",
      "url" : "/epa/medication/api/v1/fhir/MedicationRequest?_offset=30&_count=10"
    }
  ],
  "entry" : [
    {
      "fullUrl" : "http://epa4all/epa/medication/api/v1/fhir/MedicationRequest/7efae80a-a4d9-4e26-a1b9-92c72e79cfaa",
      "resource" : {
        "resourceType" : "MedicationRequest",
        "id" : "7efae80a-a4d9-4e26-a1b9-92c72e79cfaa",
        "meta" : {
          "versionId" : "2",
          "lastUpdated" : "2025-02-27T14:43:33.244Z",
          "profile" : [
            "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-request|1.3.0"
          ]
        },
        "extension" : [
          {
            "extension" : [
              {
                "url" : "indicator",
                "valueBoolean" : false
              }
            ],
            "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/multiple-prescription-extension"
          }
        ],
        "identifier" : [
          {
            "system" : "https://gematik.de/fhir/epa-medication/sid/rx-prescription-process-identifier",
            "value" : "160.100.000.000.001.39_20250227"
          },
          {
            "system" : "https://gematik.de/fhir/epa-medication/sid/rx-originator-process-identifier",
            "value" : "5e36a398-8baa-43a7-8c93-4815b8fc4211_160.100.000.000.001.39"
          }
        ],
        "status" : "completed",
        "intent" : "filler-order",
        "medicationReference" : {
          "reference" : "Medication/56ca34f1-a3f3-42f7-95a2-f5a6423c2031"
        },
        "subject" : {
          "identifier" : {
            "system" : "http://fhir.de/sid/gkv/kvid-10",
            "value" : "X110411319"
          }
        },
        "authoredOn" : "2025-02-27",
        "requester" : {
          "reference" : "PractitionerRole/73a551f8-d8cd-4b44-823d-ab5f8aeab1aa"
        },
        "dispenseRequest" : {
          "quantity" : {
            "value" : 1,
            "unit" : "Packung"
          }
        }
      },
      "search" : {
        "mode" : "match"
      }
    },
    {
      "fullUrl" : "http://epa4all/epa/medication/api/v1/fhir/MedicationRequest/3191d752-3adf-4c7f-848d-8d43766fed72",
      "resource" : {
        "resourceType" : "MedicationRequest",
        "id" : "3191d752-3adf-4c7f-848d-8d43766fed72",
        "meta" : {
          "versionId" : "2",
          "lastUpdated" : "2025-05-22T14:43:33.244Z",
          "profile" : [
            "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-request|1.3.0"
          ]
        },
        "extension" : [
          {
            "extension" : [
              {
                "url" : "indicator",
                "valueBoolean" : false
              }
            ],
            "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/multiple-prescription-extension"
          },
          {
            "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-MedicationRequest.renderedDosageInstruction",
            "valueMarkdown" : "1-0-1-0 Stück"
          },
          {
            "extension" : [
              {
                "url" : "algorithmVersion",
                "valueString" : "1.0.1"
              },
              {
                "url" : "language",
                "valueCode" : "de-DE"
              }
            ],
            "url" : "http://ig.fhir.de/igs/medication/StructureDefinition/GeneratedDosageInstructionsMeta"
          }
        ],
        "identifier" : [
          {
            "system" : "https://gematik.de/fhir/epa-medication/sid/rx-prescription-process-identifier",
            "value" : "160.100.000.000.006.24_20250520"
          },
          {
            "system" : "https://gematik.de/fhir/epa-medication/sid/rx-originator-process-identifier",
            "value" : "bb91cde8-0426-4f4b-a766-5d818d0605bd_160.100.000.000.006.24"
          }
        ],
        "status" : "active",
        "intent" : "filler-order",
        "medicationReference" : {
          "reference" : "Medication/bb91cde8-0426-4f4b-a766-5d818d0605bd"
        },
        "subject" : {
          "identifier" : {
            "system" : "http://fhir.de/sid/gkv/kvid-10",
            "value" : "X110411319"
          }
        },
        "authoredOn" : "2025-05-20",
        "requester" : {
          "reference" : "PractitionerRole/73a551f8-d8cd-4b44-823d-ab5f8aeab1aa"
        },
        "dosageInstruction" : [
          {
            "timing" : {
              "repeat" : {
                "frequency" : 2,
                "period" : 1,
                "periodUnit" : "d",
                "when" : ["MORN", "EVE"]
              }
            },
            "doseAndRate" : [
              {
                "doseQuantity" : {
                  "value" : 1,
                  "unit" : "Stück",
                  "system" : "https://fhir.kbv.de/CodeSystem/KBV_CS_SFHIR_BMP_DOSIEREINHEIT",
                  "code" : "1"
                }
              }
            ]
          }
        ],
        "dispenseRequest" : {
          "quantity" : {
            "value" : 1,
            "system" : "http://unitsofmeasure.org",
            "code" : "{Package}"
          }
        },
        "substitution" : {
          "allowedBoolean" : true
        }
      },
      "search" : {
        "mode" : "match"
      }
    },
    {
      "fullUrl" : "http://epa4all/epa/medication/api/v1/fhir/MedicationRequest/3c10c1ad-1d7a-47e8-abab-00b8299b49b8",
      "resource" : {
        "resourceType" : "MedicationRequest",
        "id" : "40df19aa-40e2-4ebc-a11d-9d232dcb0f67",
        "meta" : {
          "versionId" : "2",
          "lastUpdated" : "2025-11-27T14:43:40.244Z",
          "profile" : [
            "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-request|1.3.0"
          ]
        },
        "extension" : [
          {
            "extension" : [
              {
                "url" : "indicator",
                "valueBoolean" : false
              }
            ],
            "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/multiple-prescription-extension"
          },
          {
            "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-MedicationRequest.renderedDosageInstruction",
            "valueMarkdown" : "2mal tägl. 5ml"
          },
          {
            "extension" : [
              {
                "url" : "algorithmVersion",
                "valueString" : "1.0.1"
              },
              {
                "url" : "language",
                "valueCode" : "de-DE"
              }
            ],
            "url" : "http://ig.fhir.de/igs/medication/StructureDefinition/GeneratedDosageInstructionsMeta"
          }
        ],
        "identifier" : [
          {
            "system" : "https://gematik.de/fhir/epa-medication/sid/rx-prescription-process-identifier",
            "value" : "160.100.000.000.002.36_20251127"
          },
          {
            "system" : "https://gematik.de/fhir/epa-medication/sid/rx-originator-process-identifier",
            "value" : "f4f341f8-56b2-475b-914b-b8533c34f849_160.100.000.000.002.36"
          }
        ],
        "status" : "completed",
        "intent" : "filler-order",
        "medicationReference" : {
          "reference" : "Medication/ab8addbd-c4c7-48d2-bf4b-4a7c99f9fd6e"
        },
        "subject" : {
          "identifier" : {
            "system" : "http://fhir.de/sid/gkv/kvid-10",
            "value" : "X110411319"
          }
        },
        "authoredOn" : "2025-11-27",
        "requester" : {
          "reference" : "PractitionerRole/73a551f8-d8cd-4b44-823d-ab5f8aeab1aa"
        },
        "dosageInstruction" : [
          {
            "text" : "2mal tägl. 5ml"
          }
        ],
        "dispenseRequest" : {
          "quantity" : {
            "value" : 1,
            "unit" : "Packung"
          }
        },
        "substitution" : {
          "allowedBoolean" : true
        }
      },
      "search" : {
        "mode" : "match"
      }
    },
    {
      "fullUrl" : "http://epa4all/epa/medication/api/v1/fhir/MedicationRequest/5aeaf266-a7ee-4e9d-bcb9-3c7dde96abad",
      "resource" : {
        "resourceType" : "MedicationRequest",
        "id" : "0e7f16e4-d879-4a2c-8292-41c55201bbdd",
        "meta" : {
          "versionId" : "2",
          "lastUpdated" : "2025-12-03T14:00:00.244Z",
          "profile" : [
            "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-request|1.3.0"
          ]
        },
        "extension" : [
          {
            "extension" : [
              {
                "url" : "indicator",
                "valueBoolean" : false
              }
            ],
            "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/multiple-prescription-extension"
          },
          {
            "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-MedicationRequest.renderedDosageInstruction",
            "valueMarkdown" : "1-0-0-0 Stück"
          },
          {
            "extension" : [
              {
                "url" : "algorithmVersion",
                "valueString" : "1.0.1"
              },
              {
                "url" : "language",
                "valueCode" : "de-DE"
              }
            ],
            "url" : "http://ig.fhir.de/igs/medication/StructureDefinition/GeneratedDosageInstructionsMeta"
          }
        ],
        "identifier" : [
          {
            "system" : "https://gematik.de/fhir/epa-medication/sid/rx-prescription-process-identifier",
            "value" : "160.100.000.000.019.82_20251202"
          },
          {
            "system" : "https://gematik.de/fhir/epa-medication/sid/rx-originator-process-identifier",
            "value" : "b7791120-8913-47d4-acd0-9ae633f6d6c0_160.100.000.000.019.82"
          }
        ],
        "status" : "completed",
        "intent" : "filler-order",
        "medicationReference" : {
          "reference" : "Medication/3f0b0cb0-e8cf-4aaf-bad8-01a51619417b"
        },
        "subject" : {
          "identifier" : {
            "system" : "http://fhir.de/sid/gkv/kvid-10",
            "value" : "X110411319"
          }
        },
        "authoredOn" : "2025-12-02",
        "requester" : {
          "reference" : "PractitionerRole/73a551f8-d8cd-4b44-823d-ab5f8aeab1aa"
        },
        "dosageInstruction" : [
          {
            "timing" : {
              "repeat" : {
                "frequency" : 1,
                "period" : 1,
                "periodUnit" : "d",
                "when" : ["MORN"]
              }
            },
            "doseAndRate" : [
              {
                "doseQuantity" : {
                  "value" : 1,
                  "unit" : "Stück",
                  "system" : "https://fhir.kbv.de/CodeSystem/KBV_CS_SFHIR_BMP_DOSIEREINHEIT",
                  "code" : "1"
                }
              }
            ]
          }
        ],
        "dispenseRequest" : {
          "quantity" : {
            "value" : 1,
            "unit" : "Packung"
          }
        },
        "substitution" : {
          "allowedBoolean" : true
        }
      },
      "search" : {
        "mode" : "match"
      }
    }
  ]
}

```
