# ExampleSearchsetBundleEPAMedication - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **ExampleSearchsetBundleEPAMedication**

## Example Bundle: ExampleSearchsetBundleEPAMedication

Das bereitgestellte Beispiel dient ausschließlich als technische Illustration und soll darstellen, wie Elemente befüllt werden könnten oder wie verschiedene Instanzen zusammenhängen und hat keinen Anspruch daran, fachlich korrekt oder sinnvoll zu sein.



## Resource Content

```json
{
  "resourceType" : "Bundle",
  "id" : "example-searchset-medication",
  "type" : "searchset",
  "total" : 100,
  "link" : [
    {
      "relation" : "self",
      "url" : "/epa/medication/api/v1/fhir/Medication?_offset=20&_count=10"
    },
    {
      "relation" : "previous",
      "url" : "/epa/medication/api/v1/fhir/Medication?_offset=10&_count=10"
    },
    {
      "relation" : "next",
      "url" : "/epa/medication/api/v1/fhir/Medication?_offset=30&_count=10"
    }
  ],
  "entry" : [
    {
      "fullUrl" : "http://epa4all/epa/medication/api/v1/fhir/Medication/56ca34f1-a3f3-42f7-95a2-f5a6423c2031",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "56ca34f1-a3f3-42f7-95a2-f5a6423c2031",
        "meta" : {
          "versionId" : "2",
          "lastUpdated" : "2025-02-27T14:43:33.244Z",
          "profile" : [
            "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication|1.3.0"
          ]
        },
        "extension" : [
          {
            "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/rx-prescription-process-identifier-extension",
            "valueIdentifier" : {
              "system" : "https://gematik.de/fhir/epa-medication/sid/rx-prescription-process-identifier",
              "value" : "160.100.000.000.001.39_20250227"
            }
          },
          {
            "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-type-extension",
            "valueCoding" : {
              "system" : "http://snomed.info/sct",
              "code" : "763158003",
              "display" : "Medicinal product (product)"
            }
          },
          {
            "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/drug-category-extension",
            "valueCoding" : {
              "system" : "https://gematik.de/fhir/epa-medication/CodeSystem/epa-drug-category-cs",
              "code" : "00"
            }
          },
          {
            "url" : "http://fhir.de/StructureDefinition/normgroesse",
            "valueCode" : "N3"
          },
          {
            "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/medication-id-vaccine-extension",
            "valueBoolean" : false
          }
        ],
        "identifier" : [
          {
            "system" : "https://gematik.de/fhir/epa-medication/sid/epa-medication-unique-identifier",
            "value" : "A88662F2325484C7FF91398CACF90D38D688248B97B3624DADCD474CA3F3BBC1"
          },
          {
            "system" : "https://gematik.de/fhir/epa-medication/sid/rx-originator-process-identifier",
            "value" : "33f1aed7-ecf2-4bb4-be3a-5ec375b656b8_160.100.000.000.001.39"
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://fhir.de/CodeSystem/ifa/pzn",
              "code" : "05392039"
            }
          ],
          "text" : "Venlafaxin - 1 A Pharma® 75mg 100 Tabl. N3"
        },
        "status" : "active",
        "form" : {
          "coding" : [
            {
              "system" : "https://fhir.kbv.de/CodeSystem/KBV_CS_SFHIR_KBV_DARREICHUNGSFORM",
              "code" : "TAB"
            }
          ]
        },
        "ingredient" : [
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://fhir.de/CodeSystem/ask",
                  "code" : "24421"
                }
              ],
              "text" : "Venlafaxin"
            },
            "strength" : {
              "numerator" : {
                "value" : 75,
                "unit" : "mg"
              },
              "denominator" : {
                "value" : 1,
                "unit" : "Tbl."
              }
            }
          }
        ]
      },
      "search" : {
        "mode" : "match"
      }
    },
    {
      "fullUrl" : "http://epa4all/epa/medication/api/v1/fhir/Medication/bb91cde8-0426-4f4b-a766-5d818d0605bd",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "bb91cde8-0426-4f4b-a766-5d818d0605bd",
        "meta" : {
          "versionId" : "2",
          "lastUpdated" : "2025-05-22T14:43:33.244Z",
          "profile" : [
            "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication|1.3.0"
          ]
        },
        "extension" : [
          {
            "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/rx-prescription-process-identifier-extension",
            "valueIdentifier" : {
              "system" : "https://gematik.de/fhir/epa-medication/sid/rx-prescription-process-identifier",
              "value" : "160.100.000.000.006.24_20250520"
            }
          },
          {
            "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/drug-category-extension",
            "valueCoding" : {
              "system" : "https://gematik.de/fhir/epa-medication/CodeSystem/epa-drug-category-cs",
              "code" : "00"
            }
          },
          {
            "url" : "http://fhir.de/StructureDefinition/normgroesse",
            "valueCode" : "N1"
          },
          {
            "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/medication-id-vaccine-extension",
            "valueBoolean" : false
          }
        ],
        "identifier" : [
          {
            "system" : "https://gematik.de/fhir/epa-medication/sid/epa-medication-unique-identifier",
            "value" : "936396A4B0EAD8DE8ACD0F32BBC410523150A2F943908D3C9600AF253BE4B93A"
          },
          {
            "system" : "https://gematik.de/fhir/epa-medication/sid/rx-originator-process-identifier",
            "value" : "ec4d55a0-dec1-46b7-96cc-096845b74c4b_160.100.000.000.006.24"
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://fhir.de/CodeSystem/ifa/pzn",
              "code" : "00814665"
            }
          ],
          "text" : "Januvia® 50 mg 28 Filmtabletten N1"
        },
        "status" : "active",
        "form" : {
          "coding" : [
            {
              "system" : "https://fhir.kbv.de/CodeSystem/KBV_CS_SFHIR_KBV_DARREICHUNGSFORM",
              "code" : "FTA",
              "display" : "Tabletten"
            }
          ]
        }
      },
      "search" : {
        "mode" : "match"
      }
    },
    {
      "fullUrl" : "http://epa4all/epa/medication/api/v1/fhir/Medication/ab8addbd-c4c7-48d2-bf4b-4a7c99f9fd6e",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "ab8addbd-c4c7-48d2-bf4b-4a7c99f9fd6e",
        "meta" : {
          "versionId" : "2",
          "lastUpdated" : "2025-11-27T14:43:40.244Z",
          "profile" : [
            "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication|1.3.0"
          ]
        },
        "extension" : [
          {
            "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/rx-prescription-process-identifier-extension",
            "valueIdentifier" : {
              "system" : "https://gematik.de/fhir/epa-medication/sid/rx-prescription-process-identifier",
              "value" : "160.100.000.000.002.36_20251127"
            }
          },
          {
            "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-type-extension",
            "valueCoding" : {
              "system" : "http://snomed.info/sct",
              "code" : "763158003",
              "display" : "Medicinal product (product)"
            }
          },
          {
            "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/drug-category-extension",
            "valueCoding" : {
              "system" : "https://gematik.de/fhir/epa-medication/CodeSystem/epa-drug-category-cs",
              "code" : "00"
            }
          },
          {
            "url" : "http://fhir.de/StructureDefinition/normgroesse",
            "valueCode" : "N1"
          }
        ],
        "identifier" : [
          {
            "system" : "https://gematik.de/fhir/epa-medication/sid/epa-medication-unique-identifier",
            "value" : "1AAF4C0C8407A152A3C41728DB3DE4BBC363CD4CE6B8A2537E1CEF61DA4065ED"
          },
          {
            "system" : "https://gematik.de/fhir/epa-medication/sid/rx-originator-process-identifier",
            "value" : "4ef3e77d-fcaf-483e-8c65-c09372bb60fe_160.100.000.000.002.36"
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://fhir.de/CodeSystem/ifa/pzn",
              "code" : "08585997"
            }
          ],
          "text" : "Prospan® Hustensaft 100ml N1"
        },
        "status" : "active",
        "form" : {
          "coding" : [
            {
              "system" : "https://fhir.kbv.de/CodeSystem/KBV_CS_SFHIR_KBV_DARREICHUNGSFORM",
              "code" : "FLE"
            }
          ]
        },
        "ingredient" : [
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://fhir.de/CodeSystem/ask",
                  "code" : "50912"
                }
              ],
              "text" : "Efeublätter-Trockenextrakt (5-7,5:1); Auszugsmittel: Ethanol 30% (m/m)"
            },
            "strength" : {
              "numerator" : {
                "value" : 35,
                "unit" : "mg"
              },
              "denominator" : {
                "value" : 5,
                "unit" : "ml"
              }
            }
          }
        ]
      },
      "search" : {
        "mode" : "match"
      }
    },
    {
      "fullUrl" : "http://epa4all/epa/medication/api/v1/fhir/Medication/3f0b0cb0-e8cf-4aaf-bad8-01a51619417b",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "3f0b0cb0-e8cf-4aaf-bad8-01a51619417b",
        "meta" : {
          "versionId" : "2",
          "lastUpdated" : "2025-12-03T14:00:00.244Z",
          "profile" : [
            "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication|1.3.0"
          ]
        },
        "extension" : [
          {
            "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/rx-prescription-process-identifier-extension",
            "valueIdentifier" : {
              "system" : "https://gematik.de/fhir/epa-medication/sid/rx-prescription-process-identifier",
              "value" : "160.100.000.000.019.82_20251202"
            }
          },
          {
            "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-type-extension",
            "valueCoding" : {
              "system" : "http://snomed.info/sct",
              "code" : "763158003",
              "display" : "Medicinal product (product)"
            }
          },
          {
            "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/drug-category-extension",
            "valueCoding" : {
              "system" : "https://gematik.de/fhir/epa-medication/CodeSystem/epa-drug-category-cs",
              "code" : "00"
            }
          },
          {
            "url" : "http://fhir.de/StructureDefinition/normgroesse",
            "valueCode" : "N3"
          },
          {
            "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/medication-id-vaccine-extension",
            "valueBoolean" : false
          }
        ],
        "identifier" : [
          {
            "system" : "https://gematik.de/fhir/epa-medication/sid/epa-medication-unique-identifier",
            "value" : "6E36794F8327D7B96B74DC7E29FFCB49CC2CD859EBB58251DC1FB4456BEF92A9"
          },
          {
            "system" : "https://gematik.de/fhir/epa-medication/sid/rx-originator-process-identifier",
            "value" : "48de03e7-84f3-4724-830e-5aabca10dfa8_160.100.000.000.019.82"
          }
        ],
        "status" : "active",
        "form" : {
          "text" : "Tabletten"
        },
        "amount" : {
          "numerator" : {
            "extension" : [
              {
                "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/medication-total-quantity-formulation-extension",
                "valueString" : "100"
              }
            ],
            "unit" : "Stück"
          },
          "denominator" : {
            "value" : 1
          }
        },
        "ingredient" : [
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://fhir.de/CodeSystem/ask",
                  "code" : "22686"
                }
              ],
              "text" : "Ramipril"
            },
            "strength" : {
              "numerator" : {
                "value" : 5,
                "unit" : "mg"
              },
              "denominator" : {
                "value" : 1,
                "unit" : "Tbl."
              }
            }
          }
        ]
      },
      "search" : {
        "mode" : "match"
      }
    }
  ]
}

```
