# ExampleEpaGetMedicationListBundle - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **ExampleEpaGetMedicationListBundle**

## Example Bundle: ExampleEpaGetMedicationListBundle

Das bereitgestellte Beispiel dient ausschließlich als technische Illustration und soll darstellen, wie Elemente befüllt werden könnten oder wie verschiedene Instanzen zusammenhängen und hat keinen Anspruch daran, fachlich korrekt oder sinnvoll zu sein.



## Resource Content

```json
{
  "resourceType" : "Bundle",
  "id" : "example-get-medication-list-bundle1",
  "identifier" : {
    "system" : "urn:ietf:rfc:3986",
    "value" : "urn:uuid:9e1f5895-ab0b-4237-856d-fa1065631400"
  },
  "type" : "searchset",
  "timestamp" : "2025-01-01T00:00:00Z",
  "total" : 16,
  "link" : [
    {
      "relation" : "self",
      "url" : "http://epa4all/epa/medication/api/v1/fhir/$medication-list&date=le2025-12-24&date=ge2025-01-01&_count=10&_offset=0"
    },
    {
      "relation" : "first",
      "url" : "http://epa4all/epa/medication/api/v1/fhir/$medication-list&date=le2025-12-24&date=ge2025-01-01&_count=10&_offset=0"
    },
    {
      "relation" : "next",
      "url" : "http://epa4all/epa/medication/api/v1/fhir/$medication-list&date=le2025-12-24&date=ge2025-01-01&_count=10&_offset=10"
    },
    {
      "relation" : "last",
      "url" : "http://epa4all/epa/medication/api/v1/fhir/$medication-list&date=le2025-12-24&date=ge2025-01-01&_count=10&_offset=10"
    }
  ],
  "entry" : [
    {
      "fullUrl" : "http://epa4all/epa/medication/api/v1/fhir/Patient/641f4cf5-e54b-406c-b8a8-1d3292fd5087",
      "resource" : {
        "resourceType" : "Patient",
        "id" : "641f4cf5-e54b-406c-b8a8-1d3292fd5087",
        "meta" : {
          "profile" : [
            "https://gematik.de/fhir/epa/StructureDefinition/epa-patient|1.3.0"
          ]
        },
        "identifier" : [
          {
            "system" : "http://fhir.de/sid/gkv/kvid-10",
            "value" : "X110411319"
          }
        ],
        "name" : [
          {
            "use" : "official",
            "family" : "Mustermann",
            "given" : ["Max"]
          }
        ],
        "gender" : "male",
        "birthDate" : "1976-02-01"
      },
      "search" : {
        "mode" : "include"
      }
    },
    {
      "fullUrl" : "http://epa4all/epa/medication/api/v1/fhir/MedicationStatement/f3988023-2313-4645-bd6b-f9e37cfb6fc7",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "f3988023-2313-4645-bd6b-f9e37cfb6fc7",
        "meta" : {
          "versionId" : "2",
          "lastUpdated" : "2025-05-22T14:43:34.244Z",
          "profile" : [
            "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-statement|1.3.0"
          ]
        },
        "extension" : [
          {
            "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/rx-prescription-process-identifier-extension",
            "valueIdentifier" : {
              "system" : "https://gematik.de/fhir/epa-medication/sid/rx-prescription-process-identifier",
              "value" : "160.100.000.000.006.24_20250520"
            }
          },
          {
            "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/context-extension",
            "valueCode" : "PRESCRIPTION"
          },
          {
            "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-MedicationStatement.renderedDosageInstruction",
            "valueMarkdown" : "1-0-1-0 Stück"
          },
          {
            "extension" : [
              {
                "url" : "algorithmVersion",
                "valueString" : "1.0.1"
              },
              {
                "url" : "language",
                "valueCode" : "de-DE"
              }
            ],
            "url" : "http://ig.fhir.de/igs/medication/StructureDefinition/GeneratedDosageInstructionsMeta"
          }
        ],
        "status" : "unknown",
        "medicationReference" : {
          "reference" : "Medication/bb91cde8-0426-4f4b-a766-5d818d0605bd"
        },
        "subject" : {
          "identifier" : {
            "system" : "http://fhir.de/sid/gkv/kvid-10",
            "value" : "X110411319"
          }
        },
        "effectivePeriod" : {
          "start" : "2025-05-22"
        },
        "dateAsserted" : "2025-05-22",
        "derivedFrom" : [
          {
            "reference" : "MedicationRequest/3191d752-3adf-4c7f-848d-8d43766fed72"
          },
          {
            "reference" : "MedicationDispense/4e6e1623-778e-44a3-b208-8479f5339e43"
          }
        ],
        "dosage" : [
          {
            "timing" : {
              "repeat" : {
                "frequency" : 2,
                "period" : 1,
                "periodUnit" : "d",
                "when" : ["MORN", "EVE"]
              }
            },
            "doseAndRate" : [
              {
                "doseQuantity" : {
                  "value" : 1,
                  "unit" : "Stück",
                  "system" : "https://fhir.kbv.de/CodeSystem/KBV_CS_SFHIR_BMP_DOSIEREINHEIT",
                  "code" : "1"
                }
              }
            ]
          }
        ]
      },
      "search" : {
        "mode" : "match"
      }
    },
    {
      "fullUrl" : "http://epa4all/epa/medication/api/v1/fhir/Provenance/de42aa65-f84e-4e96-acfb-b9fd5e104b2d",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "de42aa65-f84e-4e96-acfb-b9fd5e104b2d",
        "meta" : {
          "profile" : [
            "https://gematik.de/fhir/epa/StructureDefinition/epa-activity-provenance|1.3.0"
          ]
        },
        "target" : [
          {
            "reference" : "MedicationStatement/f3988023-2313-4645-bd6b-f9e37cfb6fc7/_history/2"
          }
        ],
        "recorded" : "2025-05-22T14:43:34.244Z",
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "identifier" : {
                "system" : "https://gematik.de/fhir/sid/epa-fhir-data-service",
                "value" : "MEDICATIONSVC"
              },
              "display" : "ePA Medication Service"
            }
          }
        ]
      },
      "search" : {
        "mode" : "include"
      }
    },
    {
      "fullUrl" : "http://epa4all/epa/medication/api/v1/fhir/Medication/ec4d55a0-dec1-46b7-96cc-096845b74c4b",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "ec4d55a0-dec1-46b7-96cc-096845b74c4b",
        "meta" : {
          "profile" : [
            "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication|1.3.0"
          ]
        },
        "extension" : [
          {
            "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/drug-category-extension",
            "valueCoding" : {
              "system" : "https://gematik.de/fhir/epa-medication/CodeSystem/epa-drug-category-cs",
              "code" : "00"
            }
          },
          {
            "url" : "http://fhir.de/StructureDefinition/normgroesse",
            "valueCode" : "N1"
          },
          {
            "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/medication-id-vaccine-extension",
            "valueBoolean" : false
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://fhir.de/CodeSystem/ifa/pzn",
              "code" : "00814665"
            }
          ],
          "text" : "Januvia® 50 mg 28 Filmtabletten N1"
        },
        "status" : "active",
        "form" : {
          "coding" : [
            {
              "system" : "https://fhir.kbv.de/CodeSystem/KBV_CS_SFHIR_KBV_DARREICHUNGSFORM",
              "code" : "FTA",
              "display" : "Tabletten"
            }
          ]
        }
      },
      "search" : {
        "mode" : "include"
      }
    },
    {
      "fullUrl" : "http://epa4all/epa/medication/api/v1/fhir/MedicationRequest/bb91cde8-0426-4f4b-a766-5d818d0605bd",
      "resource" : {
        "resourceType" : "MedicationRequest",
        "id" : "3191d752-3adf-4c7f-848d-8d43766fed72",
        "meta" : {
          "versionId" : "2",
          "lastUpdated" : "2025-05-22T14:43:33.244Z",
          "profile" : [
            "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-request|1.3.0"
          ]
        },
        "extension" : [
          {
            "extension" : [
              {
                "url" : "indicator",
                "valueBoolean" : false
              }
            ],
            "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/multiple-prescription-extension"
          },
          {
            "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-MedicationRequest.renderedDosageInstruction",
            "valueMarkdown" : "1-0-1-0 Stück"
          },
          {
            "extension" : [
              {
                "url" : "algorithmVersion",
                "valueString" : "1.0.1"
              },
              {
                "url" : "language",
                "valueCode" : "de-DE"
              }
            ],
            "url" : "http://ig.fhir.de/igs/medication/StructureDefinition/GeneratedDosageInstructionsMeta"
          }
        ],
        "identifier" : [
          {
            "system" : "https://gematik.de/fhir/epa-medication/sid/rx-prescription-process-identifier",
            "value" : "160.100.000.000.006.24_20250520"
          },
          {
            "system" : "https://gematik.de/fhir/epa-medication/sid/rx-originator-process-identifier",
            "value" : "bb91cde8-0426-4f4b-a766-5d818d0605bd_160.100.000.000.006.24"
          }
        ],
        "status" : "active",
        "intent" : "filler-order",
        "medicationReference" : {
          "reference" : "Medication/bb91cde8-0426-4f4b-a766-5d818d0605bd"
        },
        "subject" : {
          "identifier" : {
            "system" : "http://fhir.de/sid/gkv/kvid-10",
            "value" : "X110411319"
          }
        },
        "authoredOn" : "2025-05-20",
        "requester" : {
          "reference" : "PractitionerRole/73a551f8-d8cd-4b44-823d-ab5f8aeab1aa"
        },
        "dosageInstruction" : [
          {
            "timing" : {
              "repeat" : {
                "frequency" : 2,
                "period" : 1,
                "periodUnit" : "d",
                "when" : ["MORN", "EVE"]
              }
            },
            "doseAndRate" : [
              {
                "doseQuantity" : {
                  "value" : 1,
                  "unit" : "Stück",
                  "system" : "https://fhir.kbv.de/CodeSystem/KBV_CS_SFHIR_BMP_DOSIEREINHEIT",
                  "code" : "1"
                }
              }
            ]
          }
        ],
        "dispenseRequest" : {
          "quantity" : {
            "value" : 1,
            "system" : "http://unitsofmeasure.org",
            "code" : "{Package}"
          }
        },
        "substitution" : {
          "allowedBoolean" : true
        }
      },
      "search" : {
        "mode" : "include"
      }
    },
    {
      "fullUrl" : "http://epa4all/epa/medication/api/v1/fhir/MedicationDispense/4e6e1623-778e-44a3-b208-8479f5339e43",
      "resource" : {
        "resourceType" : "MedicationDispense",
        "id" : "4e6e1623-778e-44a3-b208-8479f5339e43",
        "meta" : {
          "versionId" : "1",
          "lastUpdated" : "2025-05-22T14:43:33.244Z",
          "profile" : [
            "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-dispense|1.3.0"
          ]
        },
        "extension" : [
          {
            "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/rx-prescription-process-identifier-extension",
            "valueIdentifier" : {
              "system" : "https://gematik.de/fhir/epa-medication/sid/rx-prescription-process-identifier",
              "value" : "160.100.000.000.006.24_20250520"
            }
          }
        ],
        "identifier" : [
          {
            "system" : "https://gematik.de/fhir/epa-medication/sid/rx-originator-process-identifier",
            "value" : "5d8fbf7c-bdb0-44c2-95fe-423ae0404ccd_160.100.000.000.006.24"
          }
        ],
        "status" : "completed",
        "medicationReference" : {
          "reference" : "Medication/bb91cde8-0426-4f4b-a766-5d818d0605bd"
        },
        "subject" : {
          "identifier" : {
            "system" : "http://fhir.de/sid/gkv/kvid-10",
            "value" : "X110411319"
          }
        },
        "performer" : [
          {
            "actor" : {
              "reference" : "Organization/151f1697-7512-4e21-9466-1b75207475d8",
              "identifier" : {
                "type" : {
                  "coding" : [
                    {
                      "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                      "code" : "PRN",
                      "display" : "Provider number"
                    }
                  ]
                },
                "system" : "https://gematik.de/fhir/sid/telematik-id",
                "value" : "9-2.58.00000023"
              },
              "display" : "gematik Apotheke"
            }
          }
        ],
        "authorizingPrescription" : [
          {
            "reference" : "MedicationRequest/3191d752-3adf-4c7f-848d-8d43766fed72"
          }
        ],
        "whenHandedOver" : "2025-05-22",
        "substitution" : {
          "wasSubstituted" : false
        }
      },
      "search" : {
        "mode" : "include"
      }
    },
    {
      "fullUrl" : "http://epa4all/epa/medication/api/v1/fhir/PractitionerRole/73a551f8-d8cd-4b44-823d-ab5f8aeab1aa",
      "resource" : {
        "resourceType" : "PractitionerRole",
        "id" : "73a551f8-d8cd-4b44-823d-ab5f8aeab1aa",
        "practitioner" : {
          "reference" : "Practitioner/498c345f-31f5-4da6-9f04-00fa2bc8af7c",
          "identifier" : {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                  "code" : "PRN",
                  "display" : "Provider number"
                }
              ]
            },
            "system" : "https://gematik.de/fhir/sid/telematik-id",
            "value" : "1-1.58.00000056"
          },
          "display" : "Dr. Max Manfred Mustermann"
        },
        "organization" : {
          "reference" : "Organization/ad7dc0e7-cb44-4740-ba67-cb573e29d596",
          "identifier" : {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                  "code" : "PRN",
                  "display" : "Provider number"
                }
              ]
            },
            "system" : "https://gematik.de/fhir/sid/telematik-id",
            "value" : "9-2.58.00000045"
          },
          "display" : "Praxis Dr. med. Max Mustermann"
        }
      },
      "search" : {
        "mode" : "include"
      }
    },
    {
      "fullUrl" : "http://epa4all/epa/medication/api/v1/fhir/Organization/ad7dc0e7-cb44-4740-ba67-cb573e29d596",
      "resource" : {
        "resourceType" : "Organization",
        "id" : "ad7dc0e7-cb44-4740-ba67-cb573e29d596",
        "meta" : {
          "profile" : [
            "https://gematik.de/fhir/directory/StructureDefinition/OrganizationDirectory|1.0.0"
          ],
          "tag" : [
            {
              "system" : "https://gematik.de/fhir/directory/CodeSystem/Origin",
              "code" : "ldap"
            }
          ]
        },
        "identifier" : [
          {
            "system" : "https://gematik.de/fhir/sid/telematik-id",
            "value" : "9-2.58.00000045"
          },
          {
            "system" : "https://fhir.kbv.de/NamingSystem/KBV_NS_Base_BSNR",
            "value" : "012300004"
          }
        ],
        "active" : true,
        "type" : [
          {
            "coding" : [
              {
                "system" : "https://gematik.de/fhir/directory/CodeSystem/OrganizationProfessionOID",
                "code" : "1.2.276.0.76.4.50",
                "display" : "Betriebsstätte Arzt"
              }
            ]
          }
        ],
        "name" : "Praxis Dr. med. Max Mustermann",
        "address" : [
          {
            "type" : "both",
            "line" : ["Musterstr. 1", "Mitte"],
            "city" : "Darmstadt",
            "postalCode" : "64283",
            "country" : "DE"
          },
          {
            "type" : "postal",
            "line" : ["45678"],
            "city" : "Darmstadt",
            "country" : "DE"
          }
        ]
      },
      "search" : {
        "mode" : "include"
      }
    },
    {
      "fullUrl" : "http://epa4all/epa/medication/api/v1/fhir/Practitioner/498c345f-31f5-4da6-9f04-00fa2bc8af7c",
      "resource" : {
        "resourceType" : "Practitioner",
        "id" : "498c345f-31f5-4da6-9f04-00fa2bc8af7c",
        "meta" : {
          "profile" : [
            "https://gematik.de/fhir/directory/StructureDefinition/PractitionerDirectory|1.0.0"
          ],
          "tag" : [
            {
              "system" : "https://gematik.de/fhir/directory/CodeSystem/Origin",
              "code" : "ldap"
            }
          ]
        },
        "identifier" : [
          {
            "system" : "https://gematik.de/fhir/sid/telematik-id",
            "value" : "1-1.58.00000056"
          },
          {
            "system" : "https://fhir.kbv.de/NamingSystem/KBV_NS_Base_ANR",
            "value" : "123456789"
          }
        ],
        "active" : true,
        "name" : [
          {
            "text" : "Dr. Max Manfred Mustermann",
            "family" : "Musterman",
            "given" : ["Max", "Manfred"],
            "prefix" : ["Dr."]
          }
        ]
      },
      "search" : {
        "mode" : "include"
      }
    },
    {
      "fullUrl" : "http://epa4all/epa/medication/api/v1/fhir/Organization/151f1697-7512-4e21-9466-1b75207475d8",
      "resource" : {
        "resourceType" : "Organization",
        "id" : "151f1697-7512-4e21-9466-1b75207475d8",
        "meta" : {
          "profile" : [
            "https://gematik.de/fhir/directory/StructureDefinition/OrganizationDirectory|1.0.0"
          ],
          "tag" : [
            {
              "system" : "https://gematik.de/fhir/directory/CodeSystem/Origin",
              "code" : "ldap"
            }
          ]
        },
        "identifier" : [
          {
            "system" : "https://gematik.de/fhir/sid/telematik-id",
            "value" : "9-2.58.00000023"
          }
        ],
        "active" : true,
        "type" : [
          {
            "coding" : [
              {
                "system" : "https://gematik.de/fhir/directory/CodeSystem/OrganizationProfessionOID",
                "code" : "1.2.276.0.76.4.54",
                "display" : "Öffentliche Apotheke"
              }
            ]
          }
        ],
        "name" : "gematik Apotheke",
        "alias" : ["Apotheke"],
        "address" : [
          {
            "text" : "gematik Apotheke\nFriedrichstr. 136,\n10117 Berlin",
            "line" : ["Friedrichstr. 136"],
            "city" : "Berlin",
            "district" : "Mitte",
            "state" : "Berlin",
            "postalCode" : "10117",
            "country" : "DE"
          }
        ],
        "contact" : [
          {
            "purpose" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/contactentity-type",
                  "code" : "ADMIN"
                }
              ]
            },
            "name" : {
              "text" : "gematik ITSM"
            },
            "telecom" : [
              {
                "system" : "email",
                "value" : "betrieb@gematik.de"
              }
            ]
          }
        ]
      },
      "search" : {
        "mode" : "include"
      }
    },
    {
      "fullUrl" : "http://epa4all/epa/medication/api/v1/fhir/MedicationStatement/1cb0f018-178d-4488-a6b4-2be32dbda784",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "1cb0f018-178d-4488-a6b4-2be32dbda784",
        "meta" : {
          "versionId" : "1",
          "lastUpdated" : "2026-08-18T14:43:33.244Z",
          "profile" : [
            "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-statement|1.3.0"
          ]
        },
        "extension" : [
          {
            "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/context-extension",
            "valueCode" : "MANUAL"
          }
        ],
        "status" : "unknown",
        "medicationReference" : {
          "reference" : "Medication/ef5d5baf-0c42-4240-9604-7fba9cea926d"
        },
        "subject" : {
          "identifier" : {
            "system" : "http://fhir.de/sid/gkv/kvid-10",
            "value" : "X110411319"
          }
        },
        "effectivePeriod" : {
          "start" : "2026-08-18"
        },
        "dateAsserted" : "2026-08-18"
      },
      "search" : {
        "mode" : "match"
      }
    },
    {
      "fullUrl" : "http://epa4all/epa/medication/api/v1/fhir/Provenance/a9def8f0-5f57-4ee7-948d-819c3ab6e6c9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "f35a13e2-d82c-4826-97d7-b7e32721c4af",
        "meta" : {
          "profile" : [
            "https://gematik.de/fhir/epa/StructureDefinition/epa-activity-provenance|1.3.0"
          ]
        },
        "target" : [
          {
            "reference" : "MedicationStatement/1cb0f018-178d-4488-a6b4-2be32dbda784/_history/1"
          }
        ],
        "recorded" : "2026-08-18T14:43:33.344Z",
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "reference" : "Organization/8B421590-9F7F-46BE-BD1E-C987063AC4F5",
              "identifier" : {
                "type" : {
                  "coding" : [
                    {
                      "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                      "code" : "PRN"
                    }
                  ]
                },
                "system" : "https://gematik.de/fhir/sid/telematik-id",
                "value" : "9-2.58.00000060"
              },
              "display" : "Die Apotheke"
            }
          }
        ]
      },
      "search" : {
        "mode" : "include"
      }
    },
    {
      "fullUrl" : "http://epa4all/epa/medication/api/v1/fhir/Medication/ef5d5baf-0c42-4240-9604-7fba9cea926d",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "ef5d5baf-0c42-4240-9604-7fba9cea926d",
        "meta" : {
          "versionId" : "1",
          "lastUpdated" : "2026-08-18T14:43:33.244Z",
          "profile" : [
            "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication|1.3.0"
          ]
        },
        "identifier" : [
          {
            "system" : "https://gematik.de/fhir/epa-medication/sid/epa-medication-unique-identifier",
            "value" : "004C0F718C63EFADC20D838B772BD4DC4C4E6EB31293B6F689E624534A9C56CD"
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://fhir.de/CodeSystem/ifa/pzn",
              "code" : "11722423"
            }
          ],
          "text" : "IBU-RATIOPHARM direkt 400 mg Pulver zum Einnehmen 20 St Pulver"
        },
        "form" : {
          "coding" : [
            {
              "system" : "https://fhir.kbv.de/CodeSystem/KBV_CS_SFHIR_KBV_DARREICHUNGSFORM",
              "code" : "PUE",
              "display" : "Pulver zum Einnehmen"
            }
          ]
        }
      },
      "search" : {
        "mode" : "include"
      }
    },
    {
      "fullUrl" : "http://epa4all/epa/medication/api/v1/fhir/Organization/8B421590-9F7F-46BE-BD1E-C987063AC4F5",
      "resource" : {
        "resourceType" : "Organization",
        "id" : "8B421590-9F7F-46BE-BD1E-C987063AC4F5",
        "meta" : {
          "profile" : [
            "https://gematik.de/fhir/ti/StructureDefinition/ti-organization|1.1.1"
          ]
        },
        "identifier" : [
          {
            "system" : "https://gematik.de/fhir/sid/telematik-id",
            "value" : "9-2.58.00000060"
          }
        ],
        "active" : true,
        "type" : [
          {
            "coding" : [
              {
                "system" : "https://gematik.de/fhir/directory/CodeSystem/OrganizationProfessionOID",
                "code" : "1.2.276.0.76.4.54",
                "display" : "Öffentliche Apotheke"
              }
            ]
          }
        ],
        "name" : "Die Apotheke",
        "alias" : ["Apotheke"],
        "address" : [
          {
            "text" : "Die Apotheke\nFriedrichstr. 136,\n10117 Berlin",
            "line" : ["Friedrichstr. 136"],
            "city" : "Berlin",
            "district" : "Mitte",
            "state" : "Berlin",
            "postalCode" : "10117",
            "country" : "DE"
          }
        ],
        "contact" : [
          {
            "purpose" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/contactentity-type",
                  "code" : "ADMIN"
                }
              ]
            },
            "name" : {
              "text" : "gematik ITSM"
            },
            "telecom" : [
              {
                "system" : "email",
                "value" : "betrieb@gematik.de"
              }
            ]
          }
        ]
      },
      "search" : {
        "mode" : "include"
      }
    },
    {
      "fullUrl" : "http://epa4all/epa/medication/api/v1/fhir/MedicationStatement/f29f1d0c-be05-4b0d-a335-3e508da39c0c",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "f29f1d0c-be05-4b0d-a335-3e508da39c0c",
        "meta" : {
          "versionId" : "2",
          "lastUpdated" : "2026-11-01T15:43:33.244Z",
          "profile" : [
            "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-statement|1.3.0"
          ]
        },
        "extension" : [
          {
            "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/rx-prescription-process-identifier-extension",
            "valueIdentifier" : {
              "system" : "https://gematik.de/fhir/epa-medication/sid/rx-prescription-process-identifier",
              "value" : "160.100.000.000.007.24_20261101"
            }
          },
          {
            "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/context-extension",
            "valueCode" : "PRESCRIPTION"
          },
          {
            "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-MedicationStatement.renderedDosageInstruction",
            "valueMarkdown" : "1-0-0-0 Stück"
          },
          {
            "extension" : [
              {
                "url" : "algorithmVersion",
                "valueString" : "1.0.1"
              },
              {
                "url" : "language",
                "valueCode" : "de-DE"
              }
            ],
            "url" : "http://ig.fhir.de/igs/medication/StructureDefinition/GeneratedDosageInstructionsMeta"
          }
        ],
        "basedOn" : [
          {
            "extension" : [
              {
                "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/is-emp-extension",
                "valueBoolean" : true
              }
            ],
            "reference" : "MedicationRequest/266620a9-2c26-41c1-b0cb-a10947b867f5"
          }
        ],
        "status" : "unknown",
        "medicationReference" : {
          "reference" : "Medication/fc7b28e8-05ac-4ac8-86d7-7677d9c6134e"
        },
        "subject" : {
          "identifier" : {
            "system" : "http://fhir.de/sid/gkv/kvid-10",
            "value" : "X110411319"
          }
        },
        "effectivePeriod" : {
          "start" : "2025-11-01"
        },
        "dateAsserted" : "2026-11-01",
        "derivedFrom" : [
          {
            "reference" : "MedicationRequest/4dd6f19d-002c-44ac-ae2f-3c9d08ad35b8"
          },
          {
            "reference" : "MedicationDispense/fa0c29e1-c4e7-4f08-91ab-598a2233867c"
          }
        ],
        "dosage" : [
          {
            "timing" : {
              "repeat" : {
                "frequency" : 1,
                "period" : 1,
                "periodUnit" : "d",
                "when" : ["MORN"]
              }
            },
            "doseAndRate" : [
              {
                "doseQuantity" : {
                  "value" : 1,
                  "unit" : "Stück",
                  "system" : "https://fhir.kbv.de/CodeSystem/KBV_CS_SFHIR_BMP_DOSIEREINHEIT",
                  "code" : "1"
                }
              }
            ]
          }
        ]
      },
      "search" : {
        "mode" : "match"
      }
    },
    {
      "fullUrl" : "http://epa4all/epa/medication/api/v1/fhir/Provenance/176eec9c-8d5a-46a7-96e3-7af3f68c49ed",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "176eec9c-8d5a-46a7-96e3-7af3f68c49ed",
        "meta" : {
          "profile" : [
            "https://gematik.de/fhir/epa/StructureDefinition/epa-activity-provenance|1.3.0"
          ]
        },
        "target" : [
          {
            "reference" : "MedicationStatement/f29f1d0c-be05-4b0d-a335-3e508da39c0c/_history/2"
          }
        ],
        "recorded" : "2026-11-01T15:43:33.244Z",
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "identifier" : {
                "system" : "https://gematik.de/fhir/sid/epa-fhir-data-service",
                "value" : "MEDICATIONSVC"
              },
              "display" : "ePA Medication Service"
            }
          }
        ]
      },
      "search" : {
        "mode" : "include"
      }
    },
    {
      "fullUrl" : "http://epa4all/epa/medication/api/v1/fhir/Medication/fc7b28e8-05ac-4ac8-86d7-7677d9c6134e",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "fc7b28e8-05ac-4ac8-86d7-7677d9c6134e",
        "meta" : {
          "versionId" : "2",
          "lastUpdated" : "2026-11-01T14:43:33.244Z",
          "profile" : [
            "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication|1.3.0"
          ]
        },
        "extension" : [
          {
            "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/rx-prescription-process-identifier-extension",
            "valueIdentifier" : {
              "system" : "https://gematik.de/fhir/epa-medication/sid/rx-prescription-process-identifier",
              "value" : "160.100.000.000.007.24_20261101"
            }
          },
          {
            "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-type-extension",
            "valueCoding" : {
              "system" : "http://snomed.info/sct",
              "code" : "781405001",
              "display" : "Medicinal product package (product)"
            }
          },
          {
            "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/drug-category-extension",
            "valueCoding" : {
              "system" : "https://gematik.de/fhir/epa-medication/CodeSystem/epa-drug-category-cs",
              "code" : "00"
            }
          },
          {
            "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/medication-id-vaccine-extension",
            "valueBoolean" : false
          },
          {
            "url" : "http://fhir.de/StructureDefinition/normgroesse",
            "valueCode" : "N1"
          }
        ],
        "identifier" : [
          {
            "system" : "https://gematik.de/fhir/epa-medication/sid/epa-medication-unique-identifier",
            "value" : "5CA9B89A31D81FFF6869E6A93B192C03C7F715FC4A568FB060630DD639F94EF1"
          },
          {
            "system" : "https://gematik.de/fhir/epa-medication/sid/rx-originator-process-identifier",
            "value" : "a3197c39-d03c-45fa-bcb7-b32578143c56_160.100.000.000.007.24"
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://fhir.de/CodeSystem/ifa/pzn",
              "code" : "06313728"
            }
          ],
          "text" : "Sumatriptan-1a Pharma 100 mg Tabletten"
        },
        "status" : "active",
        "form" : {
          "coding" : [
            {
              "system" : "https://fhir.kbv.de/CodeSystem/KBV_CS_SFHIR_KBV_DARREICHUNGSFORM",
              "code" : "TAB",
              "display" : "Tabletten"
            }
          ]
        },
        "amount" : {
          "numerator" : {
            "extension" : [
              {
                "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/medication-total-quantity-formulation-extension",
                "valueString" : "20 St."
              }
            ],
            "value" : 20,
            "unit" : "St"
          },
          "denominator" : {
            "value" : 1
          }
        }
      },
      "search" : {
        "mode" : "include"
      }
    },
    {
      "fullUrl" : "http://epa4all/epa/medication/api/v1/fhir/MedicationRequest/4dd6f19d-002c-44ac-ae2f-3c9d08ad35b8",
      "resource" : {
        "resourceType" : "MedicationRequest",
        "id" : "4dd6f19d-002c-44ac-ae2f-3c9d08ad35b8",
        "meta" : {
          "versionId" : "2",
          "lastUpdated" : "2026-11-01T14:43:33.244Z",
          "profile" : [
            "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-request|1.3.0"
          ]
        },
        "extension" : [
          {
            "extension" : [
              {
                "url" : "indicator",
                "valueBoolean" : false
              }
            ],
            "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/multiple-prescription-extension"
          },
          {
            "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-MedicationRequest.renderedDosageInstruction",
            "valueMarkdown" : "1-0-0-0 Stück"
          },
          {
            "extension" : [
              {
                "url" : "algorithmVersion",
                "valueString" : "1.0.1"
              },
              {
                "url" : "language",
                "valueCode" : "de-DE"
              }
            ],
            "url" : "http://ig.fhir.de/igs/medication/StructureDefinition/GeneratedDosageInstructionsMeta"
          }
        ],
        "identifier" : [
          {
            "system" : "https://gematik.de/fhir/epa-medication/sid/rx-prescription-process-identifier",
            "value" : "160.100.000.000.007.24_20250425"
          },
          {
            "system" : "https://gematik.de/fhir/epa-medication/sid/rx-originator-process-identifier",
            "value" : "5f4bc41c-480e-4ee4-b58e-a99268c1a1d0_160.100.000.000.007.24"
          }
        ],
        "status" : "active",
        "intent" : "filler-order",
        "medicationReference" : {
          "reference" : "Medication/fc7b28e8-05ac-4ac8-86d7-7677d9c6134e"
        },
        "subject" : {
          "identifier" : {
            "system" : "http://fhir.de/sid/gkv/kvid-10",
            "value" : "X110411319"
          }
        },
        "authoredOn" : "2026-11-01",
        "requester" : {
          "reference" : "PractitionerRole/b9eb9668-b61e-43b5-b3ea-485234836d59"
        },
        "basedOn" : [
          {
            "identifier" : {
              "system" : "https://gematik.de/fhir/sid/emp-identifier",
              "value" : "4dd6f19d-002c-44ac-ae2f-3c9d08ad35b8"
            }
          }
        ],
        "dosageInstruction" : [
          {
            "timing" : {
              "repeat" : {
                "frequency" : 1,
                "period" : 1,
                "periodUnit" : "d",
                "when" : ["MORN"]
              }
            },
            "doseAndRate" : [
              {
                "doseQuantity" : {
                  "value" : 1,
                  "unit" : "Stück",
                  "system" : "https://fhir.kbv.de/CodeSystem/KBV_CS_SFHIR_BMP_DOSIEREINHEIT",
                  "code" : "1"
                }
              }
            ]
          }
        ],
        "dispenseRequest" : {
          "quantity" : {
            "value" : 1,
            "system" : "http://unitsofmeasure.org",
            "code" : "{Package}"
          }
        },
        "substitution" : {
          "allowedBoolean" : true
        }
      },
      "search" : {
        "mode" : "include"
      }
    },
    {
      "fullUrl" : "http://epa4all/epa/medication/api/v1/fhir/MedicationDispense/fa0c29e1-c4e7-4f08-91ab-598a2233867c",
      "resource" : {
        "resourceType" : "MedicationDispense",
        "id" : "fa0c29e1-c4e7-4f08-91ab-598a2233867c",
        "meta" : {
          "versionId" : "1",
          "lastUpdated" : "2026-11-01T15:43:33.244Z",
          "profile" : [
            "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-dispense|1.3.0"
          ]
        },
        "extension" : [
          {
            "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/rx-prescription-process-identifier-extension",
            "valueIdentifier" : {
              "system" : "https://gematik.de/fhir/epa-medication/sid/rx-prescription-process-identifier",
              "value" : "160.100.000.000.007.24_20261101"
            }
          }
        ],
        "identifier" : [
          {
            "system" : "https://gematik.de/fhir/epa-medication/sid/rx-originator-process-identifier",
            "value" : "1da91bd3-d5cb-459b-a270-32fad7d5d5d5_160.100.000.000.007.24"
          }
        ],
        "status" : "completed",
        "medicationReference" : {
          "reference" : "Medication/fc7b28e8-05ac-4ac8-86d7-7677d9c6134e"
        },
        "subject" : {
          "identifier" : {
            "system" : "http://fhir.de/sid/gkv/kvid-10",
            "value" : "X110411319"
          }
        },
        "performer" : [
          {
            "actor" : {
              "reference" : "Organization/151f1697-7512-4e21-9466-1b75207475d8",
              "identifier" : {
                "type" : {
                  "coding" : [
                    {
                      "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                      "code" : "PRN",
                      "display" : "Provider number"
                    }
                  ]
                },
                "system" : "https://gematik.de/fhir/sid/telematik-id",
                "value" : "9-2.58.00000023"
              },
              "display" : "gematik Apotheke"
            }
          }
        ],
        "authorizingPrescription" : [
          {
            "reference" : "MedicationRequest/4dd6f19d-002c-44ac-ae2f-3c9d08ad35b8"
          }
        ],
        "whenHandedOver" : "2026-11-01",
        "substitution" : {
          "wasSubstituted" : false
        }
      },
      "search" : {
        "mode" : "include"
      }
    }
  ]
}

```
