# ExampleEPABatchEmpResponseBundle - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **ExampleEPABatchEmpResponseBundle**

## Example Bundle: ExampleEPABatchEmpResponseBundle



## Resource Content

```json
{
  "resourceType" : "Bundle",
  "id" : "example-epa-batch-emp-response-bundle",
  "type" : "transaction-response",
  "entry" : [
    {
      "resource" : {
        "resourceType" : "Parameters",
        "id" : "0fe348cc-adee-496c-9359-3cf3eaa1d355",
        "meta" : {
          "profile" : [
            "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-op-emp-entry-output-parameters|1.3.0"
          ]
        },
        "parameter" : [
          {
            "name" : "empEntry",
            "resource" : {
              "resourceType" : "MedicationRequest",
              "id" : "71b66f1b-8032-4886-b7bf-e775daee22fb",
              "meta" : {
                "versionId" : "1",
                "lastUpdated" : "2026-12-01T14:00:00.400Z",
                "profile" : [
                  "https://gematik.de/fhir/epa-medication/StructureDefinition/emp-medication-request|1.3.0"
                ]
              },
              "extension" : [
                {
                  "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/context-extension",
                  "valueCode" : "EMP"
                },
                {
                  "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/reason-patient-instruction-extension",
                  "valueString" : "Bluthochdruck"
                },
                {
                  "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/patient-note-extension",
                  "valueAnnotation" : {
                    "text" : "Benazepril kann anfangs Schwindel verursachen - daher zuerst in Ruhe einnehmen und Autofahren vermeiden."
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-MedicationRequest.effectiveDosePeriod",
                  "valuePeriod" : {
                    "start" : "2026-12-01"
                  }
                },
                {
                  "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/emp-origin-medication-extension",
                  "valueReference" : {
                    "reference" : "Medication/13c66845-d0ce-43e1-9b0b-884cbbe8df7f"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-MedicationRequest.renderedDosageInstruction",
                  "valueMarkdown" : "1-0-1-0 Stück"
                },
                {
                  "extension" : [
                    {
                      "url" : "algorithmVersion",
                      "valueString" : "1.0.1"
                    },
                    {
                      "url" : "language",
                      "valueCode" : "de-DE"
                    }
                  ],
                  "url" : "http://ig.fhir.de/igs/medication/StructureDefinition/GeneratedDosageInstructionsMeta"
                }
              ],
              "identifier" : [
                {
                  "system" : "https://gematik.de/fhir/sid/emp-identifier",
                  "value" : "71b66f1b-8032-4886-b7bf-e775daee22fb"
                }
              ],
              "status" : "active",
              "intent" : "plan",
              "medicationReference" : {
                "reference" : "Medication/13c66845-d0ce-43e1-9b0b-884cbbe8df7f"
              },
              "subject" : {
                "identifier" : {
                  "system" : "http://fhir.de/sid/gkv/kvid-10",
                  "value" : "X110411319"
                }
              },
              "authoredOn" : "2026-12-01",
              "note" : [
                {
                  "text" : "Hinweis für den LE"
                }
              ],
              "dosageInstruction" : [
                {
                  "timing" : {
                    "repeat" : {
                      "frequency" : 2,
                      "period" : 1,
                      "periodUnit" : "d",
                      "when" : ["MORN", "EVE"]
                    }
                  },
                  "doseAndRate" : [
                    {
                      "doseQuantity" : {
                        "value" : 1,
                        "unit" : "Stück",
                        "system" : "https://fhir.kbv.de/CodeSystem/KBV_CS_SFHIR_BMP_DOSIEREINHEIT",
                        "code" : "1"
                      }
                    }
                  ]
                }
              ]
            }
          },
          {
            "name" : "medication",
            "resource" : {
              "resourceType" : "Medication",
              "id" : "13c66845-d0ce-43e1-9b0b-884cbbe8df7f",
              "meta" : {
                "versionId" : "1",
                "lastUpdated" : "2026-12-01T14:00:00.200Z",
                "profile" : [
                  "https://gematik.de/fhir/epa-medication/StructureDefinition/emp-medication|1.3.0"
                ]
              },
              "extension" : [
                {
                  "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/context-extension",
                  "valueCode" : "EMP"
                },
                {
                  "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-type-extension",
                  "valueCoding" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "763158003",
                    "display" : "Medicinal product (product)"
                  }
                },
                {
                  "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/drug-category-extension",
                  "valueCoding" : {
                    "system" : "https://gematik.de/fhir/epa-medication/CodeSystem/epa-drug-category-cs",
                    "code" : "00"
                  }
                },
                {
                  "url" : "http://fhir.de/StructureDefinition/normgroesse",
                  "valueCode" : "N3"
                },
                {
                  "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/medication-id-vaccine-extension",
                  "valueBoolean" : false
                }
              ],
              "identifier" : [
                {
                  "system" : "https://gematik.de/fhir/epa-medication/sid/epa-medication-unique-identifier",
                  "value" : "D15E4956F59A13CD3BB365799857D6FA9757C62D36DBDB9578D018CA4B6D969F"
                }
              ],
              "code" : {
                "coding" : [
                  {
                    "system" : "http://fhir.de/CodeSystem/ifa/pzn",
                    "code" : "04351736",
                    "display" : "Benazepril AL 20mg 98 Filmtabletten N3"
                  }
                ],
                "text" : "Benazepril AL 20mg 98 Filmtabletten N3"
              },
              "status" : "active",
              "form" : {
                "coding" : [
                  {
                    "system" : "https://fhir.kbv.de/CodeSystem/KBV_CS_SFHIR_KBV_DARREICHUNGSFORM",
                    "code" : "FTA"
                  }
                ]
              },
              "amount" : {
                "numerator" : {
                  "extension" : [
                    {
                      "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/medication-total-quantity-formulation-extension",
                      "valueString" : "98"
                    }
                  ],
                  "unit" : "Stück"
                },
                "denominator" : {
                  "value" : 1
                }
              },
              "ingredient" : [
                {
                  "itemCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "http://fhir.de/CodeSystem/ask",
                        "code" : "23413"
                      }
                    ],
                    "text" : "Benazepril hydrochlorid"
                  },
                  "strength" : {
                    "numerator" : {
                      "value" : 20,
                      "unit" : "mg"
                    },
                    "denominator" : {
                      "value" : 1,
                      "unit" : "Filmtbl."
                    }
                  }
                }
              ]
            }
          },
          {
            "name" : "relatedActivity",
            "resource" : {
              "resourceType" : "Provenance",
              "id" : "8faa45dd-b2dc-4a80-8956-94aeab1db04b",
              "meta" : {
                "profile" : [
                  "https://gematik.de/fhir/epa/StructureDefinition/epa-activity-provenance|1.3.0"
                ]
              },
              "target" : [
                {
                  "reference" : "MedicationRequest/71b66f1b-8032-4886-b7bf-e775daee22fb/_history/1"
                }
              ],
              "recorded" : "2026-12-01T14:00:00.600Z",
              "activity" : {
                "coding" : [
                  {
                    "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
                    "code" : "CREATE"
                  }
                ]
              },
              "agent" : [
                {
                  "type" : {
                    "coding" : [
                      {
                        "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                        "code" : "author"
                      }
                    ]
                  },
                  "who" : {
                    "reference" : "Organization/450a9511-53e5-4af7-be36-a18444bb8dd2",
                    "identifier" : {
                      "type" : {
                        "coding" : [
                          {
                            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                            "code" : "PRN"
                          }
                        ]
                      },
                      "system" : "https://gematik.de/fhir/sid/telematik-id",
                      "value" : "9-2.58.00000089"
                    },
                    "display" : "Die Hausarztpraxis"
                  }
                }
              ]
            }
          }
        ]
      },
      "response" : {
        "status" : "200 OK"
      }
    },
    {
      "resource" : {
        "resourceType" : "Parameters",
        "id" : "946af3ef-eec2-4a5d-81c4-fe46bc115d58",
        "meta" : {
          "profile" : [
            "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-op-emp-entry-output-parameters|1.3.0"
          ]
        },
        "parameter" : [
          {
            "name" : "empEntry",
            "resource" : {
              "resourceType" : "MedicationRequest",
              "id" : "266620a9-2c26-41c1-b0cb-a10947b867f5",
              "meta" : {
                "versionId" : "3",
                "lastUpdated" : "2026-12-01T14:00:00.400Z",
                "profile" : [
                  "https://gematik.de/fhir/epa-medication/StructureDefinition/emp-medication-request|1.3.0"
                ]
              },
              "extension" : [
                {
                  "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/context-extension",
                  "valueCode" : "EMP"
                },
                {
                  "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/reason-patient-instruction-extension",
                  "valueString" : "akuten Behandlung von Migräneanfällen mit und ohne Aura"
                },
                {
                  "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/patient-note-extension",
                  "valueAnnotation" : {
                    "text" : "Bitte schützen Sie das Arzneimittel vor hohen Temperaturen und direkter Sonneneinstrahlung."
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-MedicationRequest.effectiveDosePeriod",
                  "valuePeriod" : {
                    "start" : "2026-12-01",
                    "end" : "2027-02-01"
                  }
                },
                {
                  "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/emp-origin-medication-extension",
                  "valueReference" : {
                    "reference" : "Medication/87f08ba2-da7e-467e-86aa-404d9035297c"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-MedicationRequest.renderedDosageInstruction",
                  "valueMarkdown" : "1-0-0-0 Stück"
                },
                {
                  "extension" : [
                    {
                      "url" : "algorithmVersion",
                      "valueString" : "1.0.1"
                    },
                    {
                      "url" : "language",
                      "valueCode" : "de-DE"
                    }
                  ],
                  "url" : "http://ig.fhir.de/igs/medication/StructureDefinition/GeneratedDosageInstructionsMeta"
                },
                {
                  "extension" : [
                    {
                      "url" : "reference",
                      "valueReference" : {
                        "reference" : "MedicationStatement/f29f1d0c-be05-4b0d-a335-3e508da39c0c"
                      }
                    },
                    {
                      "url" : "addedOn",
                      "valueDateTime" : "2026-12-01T14:00:00.400Z"
                    }
                  ],
                  "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/emp-medicationrequest-activity-extension"
                }
              ],
              "identifier" : [
                {
                  "system" : "https://gematik.de/fhir/sid/emp-identifier",
                  "value" : "266620a9-2c26-41c1-b0cb-a10947b867f5"
                }
              ],
              "status" : "active",
              "intent" : "plan",
              "medicationReference" : {
                "reference" : "Medication/87f08ba2-da7e-467e-86aa-404d9035297c"
              },
              "subject" : {
                "identifier" : {
                  "system" : "http://fhir.de/sid/gkv/kvid-10",
                  "value" : "X110411319"
                }
              },
              "authoredOn" : "2026-11-01",
              "note" : [
                {
                  "text" : "Hinweis für den LE"
                }
              ],
              "dosageInstruction" : [
                {
                  "timing" : {
                    "repeat" : {
                      "frequency" : 1,
                      "period" : 1,
                      "periodUnit" : "d",
                      "when" : ["MORN"]
                    }
                  },
                  "doseAndRate" : [
                    {
                      "doseQuantity" : {
                        "value" : 1,
                        "unit" : "Stück",
                        "system" : "https://fhir.kbv.de/CodeSystem/KBV_CS_SFHIR_BMP_DOSIEREINHEIT",
                        "code" : "1"
                      }
                    }
                  ]
                }
              ]
            }
          },
          {
            "name" : "medication",
            "resource" : {
              "resourceType" : "Medication",
              "id" : "87f08ba2-da7e-467e-86aa-404d9035297c",
              "meta" : {
                "versionId" : "1",
                "lastUpdated" : "2026-11-01T14:00:00.200Z",
                "profile" : [
                  "https://gematik.de/fhir/epa-medication/StructureDefinition/emp-medication|1.3.0"
                ]
              },
              "extension" : [
                {
                  "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/context-extension",
                  "valueCode" : "EMP"
                },
                {
                  "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-type-extension",
                  "valueCoding" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "781405001",
                    "display" : "Medicinal product package (product)"
                  }
                },
                {
                  "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/drug-category-extension",
                  "valueCoding" : {
                    "system" : "https://gematik.de/fhir/epa-medication/CodeSystem/epa-drug-category-cs",
                    "code" : "00"
                  }
                },
                {
                  "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/medication-id-vaccine-extension",
                  "valueBoolean" : false
                },
                {
                  "url" : "http://fhir.de/StructureDefinition/normgroesse",
                  "valueCode" : "N1"
                }
              ],
              "identifier" : [
                {
                  "system" : "https://gematik.de/fhir/epa-medication/sid/epa-medication-unique-identifier",
                  "value" : "5CA9B89A31D81FFF6869E6A93B192C03C7F715FC4A568FB060630DD639F94EF1"
                }
              ],
              "code" : {
                "coding" : [
                  {
                    "system" : "http://fhir.de/CodeSystem/ifa/pzn",
                    "code" : "06313728"
                  }
                ],
                "text" : "Sumatriptan-1a Pharma 100 mg Tabletten"
              },
              "status" : "active",
              "form" : {
                "coding" : [
                  {
                    "system" : "https://fhir.kbv.de/CodeSystem/KBV_CS_SFHIR_KBV_DARREICHUNGSFORM",
                    "code" : "TAB",
                    "display" : "Tabletten"
                  }
                ]
              },
              "amount" : {
                "numerator" : {
                  "extension" : [
                    {
                      "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/medication-total-quantity-formulation-extension",
                      "valueString" : "20 St."
                    }
                  ],
                  "value" : 20,
                  "unit" : "St"
                },
                "denominator" : {
                  "value" : 1
                }
              }
            }
          },
          {
            "name" : "relatedActivity",
            "resource" : {
              "resourceType" : "Provenance",
              "id" : "20335453-d103-4957-a370-03c9007db2f6",
              "meta" : {
                "profile" : [
                  "https://gematik.de/fhir/epa/StructureDefinition/epa-activity-provenance|1.3.0"
                ]
              },
              "target" : [
                {
                  "reference" : "MedicationRequest/266620a9-2c26-41c1-b0cb-a10947b867f5/_history/3"
                }
              ],
              "recorded" : "2026-12-01T14:00:00.400Z",
              "activity" : {
                "coding" : [
                  {
                    "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
                    "code" : "CREATE"
                  }
                ]
              },
              "agent" : [
                {
                  "type" : {
                    "coding" : [
                      {
                        "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                        "code" : "author"
                      }
                    ]
                  },
                  "who" : {
                    "reference" : "Organization/450a9511-53e5-4af7-be36-a18444bb8dd2",
                    "identifier" : {
                      "type" : {
                        "coding" : [
                          {
                            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                            "code" : "PRN"
                          }
                        ]
                      },
                      "system" : "https://gematik.de/fhir/sid/telematik-id",
                      "value" : "9-2.58.00000089"
                    },
                    "display" : "Die Hausarztpraxis"
                  }
                }
              ]
            }
          }
        ]
      },
      "response" : {
        "status" : "200 OK"
      }
    },
    {
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "319fcc6e-049d-4eb1-9a5c-82c33438cf94",
        "meta" : {
          "profile" : [
            "https://gematik.de/fhir/epa-medication/StructureDefinition/emp-chronology-provenance|1.3.0"
          ]
        },
        "extension" : [
          {
            "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/is-emp-chronology-extension",
            "valueBoolean" : true
          }
        ],
        "target" : [
          {
            "reference" : "MedicationRequest/266620a9-2c26-41c1-b0cb-a10947b867f5/_history/3"
          },
          {
            "reference" : "MedicationRequest/71b66f1b-8032-4886-b7bf-e775daee22fb/_history/1"
          }
        ],
        "occurredDateTime" : "2026-12-01T14:00:00.400Z",
        "recorded" : "2026-12-01T14:00:00.400Z",
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "reference" : "Organization/450a9511-53e5-4af7-be36-a18444bb8dd2",
              "identifier" : {
                "type" : {
                  "coding" : [
                    {
                      "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                      "code" : "PRN"
                    }
                  ]
                },
                "system" : "https://gematik.de/fhir/sid/telematik-id",
                "value" : "9-2.58.00000089"
              },
              "display" : "Die Hausarztpraxis"
            }
          }
        ]
      },
      "response" : {
        "status" : "200 OK"
      }
    }
  ]
}

```
