<?xml version="1.0" encoding="UTF-8"?>
<sch:schema xmlns:sch="http://purl.oclc.org/dsdl/schematron" queryBinding="xslt2">
  <sch:ns prefix="f" uri="http://hl7.org/fhir"/>
  <sch:ns prefix="h" uri="http://www.w3.org/1999/xhtml"/>
  <!-- 
    This file contains just the constraints for the profile Bundle
    It includes the base constraints for the resource as well.
    Because of the way that schematrons and containment work, 
    you may need to use this schematron fragment to build a, 
    single schematron that validates contained resources (if you have any) 
  -->
  <sch:pattern>
    <sch:title>f:Bundle</sch:title>
    <sch:rule context="f:Bundle">
      <sch:assert test="count(f:link) &lt;= 0">link: maximum cardinality of 'link' is 0</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:Bundle/f:meta</sch:title>
    <sch:rule context="f:Bundle/f:meta">
      <sch:assert test="count(f:id) &lt;= 1">id: maximum cardinality of 'id' is 1</sch:assert>
      <sch:assert test="count(f:versionId) &lt;= 1">versionId: maximum cardinality of 'versionId' is 1</sch:assert>
      <sch:assert test="count(f:lastUpdated) &lt;= 1">lastUpdated: maximum cardinality of 'lastUpdated' is 1</sch:assert>
      <sch:assert test="count(f:source) &lt;= 1">source: maximum cardinality of 'source' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:Bundle/f:entry</sch:title>
    <sch:rule context="f:Bundle/f:entry">
      <sch:assert test="count(f:resource) &gt;= 1">resource: minimum cardinality of 'resource' is 1</sch:assert>
      <sch:assert test="count(f:search) &lt;= 0">search: maximum cardinality of 'search' is 0</sch:assert>
      <sch:assert test="count(f:response) &lt;= 0">response: maximum cardinality of 'response' is 0</sch:assert>
      <sch:assert test="count(f:resource) &gt;= 1">resource: minimum cardinality of 'resource' is 1</sch:assert>
      <sch:assert test="count(f:search) &lt;= 0">search: maximum cardinality of 'search' is 0</sch:assert>
      <sch:assert test="count(f:response) &lt;= 0">response: maximum cardinality of 'response' is 0</sch:assert>
      <sch:assert test="count(f:resource) &gt;= 1">resource: minimum cardinality of 'resource' is 1</sch:assert>
      <sch:assert test="count(f:search) &lt;= 0">search: maximum cardinality of 'search' is 0</sch:assert>
      <sch:assert test="count(f:response) &lt;= 0">response: maximum cardinality of 'response' is 0</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:Bundle/f:entry/f:request</sch:title>
    <sch:rule context="f:Bundle/f:entry/f:request">
      <sch:assert test="count(f:ifNoneMatch) &lt;= 0">ifNoneMatch: maximum cardinality of 'ifNoneMatch' is 0</sch:assert>
      <sch:assert test="count(f:ifModifiedSince) &lt;= 0">ifModifiedSince: maximum cardinality of 'ifModifiedSince' is 0</sch:assert>
      <sch:assert test="count(f:ifMatch) &lt;= 0">ifMatch: maximum cardinality of 'ifMatch' is 0</sch:assert>
      <sch:assert test="count(f:ifNoneExist) &lt;= 0">ifNoneExist: maximum cardinality of 'ifNoneExist' is 0</sch:assert>
      <sch:assert test="count(f:ifNoneMatch) &lt;= 0">ifNoneMatch: maximum cardinality of 'ifNoneMatch' is 0</sch:assert>
      <sch:assert test="count(f:ifModifiedSince) &lt;= 0">ifModifiedSince: maximum cardinality of 'ifModifiedSince' is 0</sch:assert>
      <sch:assert test="count(f:ifMatch) &lt;= 0">ifMatch: maximum cardinality of 'ifMatch' is 0</sch:assert>
      <sch:assert test="count(f:ifNoneExist) &lt;= 0">ifNoneExist: maximum cardinality of 'ifNoneExist' is 0</sch:assert>
      <sch:assert test="count(f:ifNoneMatch) &lt;= 0">ifNoneMatch: maximum cardinality of 'ifNoneMatch' is 0</sch:assert>
      <sch:assert test="count(f:ifModifiedSince) &lt;= 0">ifModifiedSince: maximum cardinality of 'ifModifiedSince' is 0</sch:assert>
      <sch:assert test="count(f:ifMatch) &lt;= 0">ifMatch: maximum cardinality of 'ifMatch' is 0</sch:assert>
      <sch:assert test="count(f:ifNoneExist) &lt;= 0">ifNoneExist: maximum cardinality of 'ifNoneExist' is 0</sch:assert>
    </sch:rule>
  </sch:pattern>
</sch:schema>
